/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.appframework.simplemq;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.diylc.appframework.simplemq.IMessageListener;

public class MessageDispatcher<E extends Enum<E>> {
    private static final Logger LOG = Logger.getLogger(MessageDispatcher.class);
    private Map<IMessageListener<E>, EnumSet<E>> listenerMap;
    private Object mutex = new Object();
    private ExecutorService threadFactory;
    private final boolean synchronous;

    public MessageDispatcher(boolean synchronous) {
        this.synchronous = synchronous;
        this.listenerMap = new HashMap<IMessageListener<E>, EnumSet<E>>();
        if (!synchronous) {
            this.threadFactory = Executors.newCachedThreadPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(IMessageListener<E> listener) {
        if (listener.getSubscribedEventTypes() != null) {
            Object object = this.mutex;
            synchronized (object) {
                this.listenerMap.put(listener, listener.getSubscribedEventTypes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(IMessageListener<E> listener) {
        Object object = this.mutex;
        synchronized (object) {
            this.listenerMap.remove(listener);
        }
    }

    public void dispatchMessage(E eventType, Object ... params) {
        if (this.synchronous) {
            ArrayList<IMessageListener<E>> listeners = new ArrayList<IMessageListener<E>>();
            for (Map.Entry<IMessageListener<E>, EnumSet<E>> entry : this.listenerMap.entrySet()) {
                if (!entry.getValue().contains(eventType)) continue;
                listeners.add(entry.getKey());
            }
            for (IMessageListener iMessageListener : listeners) {
                try {
                    iMessageListener.processMessage(eventType, params);
                }
                catch (Exception e) {
                    LOG.error((Object)"Listener threw an exception", (Throwable)e);
                }
            }
        } else {
            this.threadFactory.execute(new EventRunnable(this, eventType, params));
        }
    }

    static class EventRunnable
    implements Runnable {
        private E eventType;
        private Object[] params;
        final /* synthetic */ MessageDispatcher this$0;

        public EventRunnable(E eventType, Object[] params) {
            this.this$0 = var1_1;
            this.eventType = eventType;
            this.params = params;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList listeners = new ArrayList();
            Object object = this.this$0.mutex;
            synchronized (object) {
                for (Map.Entry entry : this.this$0.listenerMap.entrySet()) {
                    if (!((EnumSet)entry.getValue()).contains(this.eventType)) continue;
                    listeners.add(entry.getKey());
                }
            }
            for (IMessageListener listener : listeners) {
                try {
                    listener.processMessage(this.eventType, this.params);
                }
                catch (Exception e) {
                    LOG.error((Object)"Listener threw an exception", (Throwable)e);
                }
            }
        }
    }
}

