/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import com.amazon.aes.webservices.client.ImageAttribute;
import com.amazon.aes.webservices.client.ImageMapAttributeItem;
import com.amazon.aes.webservices.client.InvalidMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageMapAttribute
extends ImageAttribute {
    public static final String MAPPINGS_SEPARATOR = ",";
    public static final String MAPPINGS_INDICATOR = "=";
    public static final Pattern MAPPINGS_REGEX = Pattern.compile("^(\\w+)\\s*=\\s*(\\S+)$");
    public Set<ImageMapAttributeItem> items = new HashSet<ImageMapAttributeItem>();

    public ImageMapAttribute(ImageAttribute.ImageAttributeType _type) {
        super(_type);
    }

    public void addImageMapAttributeItems(ImageMapAttributeItem.ImageMapAttributeItemType type, String mappings) throws InvalidMapping {
        if (mappings != null) {
            ArrayList<String> mappingsList = new ArrayList<String>(Arrays.asList(mappings.split(MAPPINGS_SEPARATOR)));
            for (String mapping : mappingsList) {
                Matcher matcher = MAPPINGS_REGEX.matcher(mapping.trim());
                if (matcher.matches()) {
                    this.addImageMapAttributeItem(type, matcher.group(1), matcher.group(2));
                    continue;
                }
                throw new InvalidMapping(mapping);
            }
        } else {
            throw new InvalidMapping(mappings);
        }
    }

    public boolean addImageMapAttributeItem(ImageMapAttributeItem.ImageMapAttributeItemType type, Map.Entry<String, String> mapping) {
        if (mapping != null) {
            return this.addImageMapAttributeItem(type, mapping.getKey(), mapping.getValue());
        }
        return false;
    }

    public boolean addImageMapAttributeItem(ImageMapAttributeItem.ImageMapAttributeItemType type, String key, String value) {
        if (this.itemTypeCompatible(type)) {
            return this.items.add(new ImageMapAttributeItem(type, key, value));
        }
        return false;
    }

    public abstract boolean itemTypeCompatible(ImageMapAttributeItem.ImageMapAttributeItemType var1);
}

