/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.util;

import com.amazon.aes.util.HttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.util.DateUtil;
import org.bouncycastle.crypto.digests.MD5Digest;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3Utils {
    public static int numRetries = 3;
    public static int numRedirects = 3;
    public static boolean calculateUploadMD5 = false;
    protected static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    protected static Callable<HttpClient> customGetClient = null;

    public static void setGetClient(Callable<HttpClient> callable) {
        customGetClient = callable;
    }

    public static HttpClient getClient() throws IOException {
        if (customGetClient != null) {
            try {
                return customGetClient.call();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                IOException x = new IOException();
                x.initCause(e);
                throw x;
            }
        }
        return HttpUtils.getClient();
    }

    public static HeadMethod head(String url, String bucket, String subresource, String user, String pass) throws IOException {
        HttpClient client = S3Utils.getClient();
        HeadMethod head = new HeadMethod(url);
        head.setFollowRedirects(true);
        S3Utils.signRequest((HttpMethodBase)head, bucket, subresource, user, pass);
        S3Utils.withRetry(client, (HttpMethodBase)head, numRetries, numRedirects);
        return head;
    }

    public static GetMethod get(String url, String bucket, String subresource, String user, String pass) throws IOException {
        HttpClient client = S3Utils.getClient();
        GetMethod get = new GetMethod(url);
        get.setFollowRedirects(true);
        S3Utils.signRequest((HttpMethodBase)get, bucket, subresource, user, pass);
        S3Utils.withRetry(client, (HttpMethodBase)get, numRetries, numRedirects);
        return get;
    }

    public static PutMethod put(String url, String bucket, String subresource, String body, String user, String pass) throws IOException {
        return S3Utils.put(url, bucket, subresource, body, user, pass, null);
    }

    public static PutMethod put(String url, String bucket, String subresource, String body, String user, String pass, Map<String, String> options) throws IOException {
        HttpClient client = S3Utils.getClient();
        PutMethod put = new PutMethod(url);
        if (body == null) {
            put.addRequestHeader("Content-Length", "0");
        } else {
            put.setRequestEntity((RequestEntity)new StringRequestEntity(body));
        }
        put.addRequestHeader("Content-Type", "text/plain");
        if (options != null) {
            for (Map.Entry<String, String> option : options.entrySet()) {
                put.addRequestHeader(option.getKey(), option.getValue());
            }
        }
        S3Utils.signRequest((HttpMethodBase)put, bucket, subresource, user, pass);
        S3Utils.withRetry(client, (HttpMethodBase)put, numRetries, numRedirects);
        return put;
    }

    public static PutMethod put(String url, String bucket, String subresource, InputStream body, String mimeType, String user, String pass, Map<String, String> options) throws IOException {
        HttpClient client = S3Utils.getClient();
        PutMethod put = new PutMethod(url);
        if (calculateUploadMD5) {
            int len;
            MD5Digest md5Digest = new MD5Digest();
            ByteArrayOutputStream tmpStream = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            while ((len = body.read(buf)) != -1) {
                md5Digest.update(buf, 0, len);
                tmpStream.write(buf, 0, len);
            }
            byte[] digest = new byte[16];
            md5Digest.doFinal(digest, 0);
            put.addRequestHeader("Content-MD5", new BASE64Encoder().encode(digest));
            put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(tmpStream.toByteArray()));
        } else {
            put.setRequestEntity((RequestEntity)new InputStreamRequestEntity(body));
        }
        if (mimeType != null && mimeType.length() > 0) {
            put.addRequestHeader("Content-Type", mimeType);
        }
        if (options != null) {
            for (Map.Entry<String, String> option : options.entrySet()) {
                put.addRequestHeader(option.getKey(), option.getValue());
            }
        }
        S3Utils.signRequest((HttpMethodBase)put, bucket, subresource, user, pass);
        S3Utils.withRetry(client, (HttpMethodBase)put, numRetries, 3);
        return put;
    }

    public static void signRequest(HttpMethodBase method, String bucket, String subresource, String user, String pass) throws URIException {
        method.addRequestHeader("Date", DateUtil.formatDate((Date)new Date()));
        if (user != null && pass != null) {
            String auth = S3Utils.getRequestAuth(method, bucket, subresource, user, pass);
            method.addRequestHeader("Authorization", auth);
        }
    }

    public static String getRequestAuth(HttpMethodBase method, String bucket, String subresource, String user, String pass) throws URIException {
        boolean emptyContentMD5Header;
        StringBuilder buf = new StringBuilder();
        buf.append(method.getName() + "\n");
        boolean bl = emptyContentMD5Header = method.getRequestHeader("Content-MD5") == null;
        if (emptyContentMD5Header) {
            method.setRequestHeader("Content-MD5", "");
        }
        if (method.getRequestHeader("Content-Type") == null) {
            method.setRequestHeader("Content-Type", "");
        }
        TreeMap<String, String> headerNames = new TreeMap<String, String>();
        for (Header header : method.getRequestHeaders()) {
            headerNames.put(header.getName().toLowerCase(), header.getName());
        }
        for (String name : headerNames.keySet()) {
            if (name.equals("content-type") || name.equals("content-md5") || name.equals("date")) {
                buf.append(method.getRequestHeader((String)headerNames.get(name)).getValue() + "\n");
                continue;
            }
            if (!name.startsWith("x-amz-")) continue;
            buf.append(name + ":");
            buf.append(method.getRequestHeader((String)headerNames.get(name)).getValue() + "\n");
        }
        if (bucket != null) {
            buf.append("/").append(bucket);
        }
        buf.append(method.getURI().getPath());
        if (subresource != null) {
            buf.append("?" + subresource);
        }
        try {
            String i$ = "AWS " + user + ":" + S3Utils.getBase64OfHmacSHA1(buf.toString(), pass);
            return i$;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot make the digest!", e);
        }
        finally {
            if (emptyContentMD5Header) {
                method.removeRequestHeader("Content-MD5");
            }
        }
    }

    protected static String getBase64OfHmacSHA1(String data, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        return new BASE64Encoder().encode(mac.doFinal(data.getBytes()));
    }

    public static int withRetry(HttpClient client, HttpMethodBase method, int retries) throws IOException {
        return S3Utils.withRetry(client, method, retries, 0);
    }

    public static int withRetry(HttpClient client, HttpMethodBase method, int retries, int followRedirects) throws IOException {
        IOException lastException = null;
        int i = 0;
        int redirects = 0;
        int code = 0;
        do {
            try {
                Header location;
                lastException = null;
                code = client.executeMethod((HttpMethod)method);
                if (redirects < followRedirects && (code == 301 || code == 307) && (location = method.getResponseHeader("Location")) != null && location.getValue() != null && location.getValue().length() > 0) {
                    method.setURI((URI)new HttpsURL(location.getValue()));
                    ++redirects;
                    continue;
                }
                if (code < 500) {
                    return code;
                }
            }
            catch (IOException e) {
                lastException = e;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            ++i;
        } while (i < retries);
        if (lastException != null) {
            throw lastException;
        }
        return code;
    }
}

