/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AddGroup
extends BaseCmd {
    private static final String DESCRIPTION_ARG = "GROUP-DESCRIPTION";
    private static final String DESCRIPTION_DESC = "A more verbose description of the group being created.";

    public AddGroup(String[] args) {
        super("ec2addgrp", "ec2-add-group");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"description");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)DESCRIPTION_ARG);
        OptionBuilder.withDescription((String)DESCRIPTION_DESC);
        result.addOption(OptionBuilder.create((String)"d"));
        return result;
    }

    protected String getOptionString() {
        return "GROUP -d GROUP-DESCRIPTION";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Create a new security group.");
        System.out.println("     The GROUP parameter is the name of the new group.");
    }

    public void printOptions() {
        super.printOptions();
        this.printOption("description");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("GROUP");
        this.assertOptionSet("description");
        String name = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        String description = this.getOptionValue("description");
        RequestResultPair res = jec2.createSecurityGroup(name, description);
        if (((Boolean)res.getResponse()).booleanValue()) {
            out.outputGroup(System.out, name, description);
            out.printRequestId(System.out, (RequestResult)res);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new AddGroup(args).invoke();
    }
}

