/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.SecurityGroupDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public abstract class AuthRevBase
extends BaseCmd {
    private static final String[] SOURCE_SUBNET_DESC = new String[]{"The network source from which traffic is to be authorized, specified", "as a CIDR subnet range, e.g. 205.192.8.45/24. This may be specified", "more than once to allow traffic from multiple subnets."};
    private static final String SOURCE_SUBNET_ARG = "SOURCE-SUBNET";
    private static final String[] SOURCE_GROUP_USER_DESC = new String[]{"The owner of the security group specified using -o. If specified only", "once, the same user will be used for all specified groups. However, if", "specified once per -o, each user is mapped to a group in order.", "Anything else is invalid."};
    private static final String SOURCE_GROUP_USER_ARG = "SOURCE-GROUP-USER [--source-group-user...]";
    private static final String[] SOURCE_GROUP_DESC = new String[]{"Network source from which traffic is to be authorized, specified as", "an EC2 security group name, e.g. default. This may be specified more", "than once to allow network traffic from multiple security groups."};
    private static final String SOURCE_GROUP_ARG = "SOURCE-GROUP [--source-group...]";
    private static final String[] ICMP_TYPE_CODE_DESC = new String[]{"icmp type and code. If the icmp protocol is specified, then icmp type", "and code may optionally be specified as type:code, where both type and", "code are integers and compliant with RFC792. Type or code (or both) may", "be specified as -1 which is a wildcard covering all types or codes."};
    private static final String ICMP_TYPE_CODE_ARG = "TYPE:CODE";
    private static final String[] PORT_RANGE_DESC = new String[]{"Range of ports to open. If the tcp or udp protocol are specified (or", "implied by default), then the range of ports to grant access to may ", "optionally be specified as a single integer, or as a range (min-max)."};
    private static final String[] PROTOCOL_DESC = new String[]{"tcp, udp or icmp (must be lower case). If not specified, the protocol", "defaults to tcp if source subnet is specified (or implied by default),", "or all-protocols if source group is specified (to ensure backwards ", "compatibility)"};
    private static final String PORT_RANGE_ARG = "PORT-RANGE";
    private static final String PROTOCOL_ARG = "PROTOCOL";

    public AuthRevBase(String s, String l, String[] args) {
        super(s, l);
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"protocol");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)PROTOCOL_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(PROTOCOL_DESC));
        result.addOption(OptionBuilder.create((String)"P"));
        OptionBuilder.withLongOpt((String)"port-range");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)PORT_RANGE_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(PORT_RANGE_DESC));
        result.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"source-subnet");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)SOURCE_SUBNET_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(SOURCE_SUBNET_DESC));
        result.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"source-group");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)SOURCE_GROUP_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(SOURCE_GROUP_DESC));
        result.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"source-group-user");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)SOURCE_GROUP_USER_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(SOURCE_GROUP_USER_DESC));
        result.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withLongOpt((String)"icmp-type-code");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)ICMP_TYPE_CODE_ARG);
        OptionBuilder.withDescription((String)AuthRevBase.joinDescription(ICMP_TYPE_CODE_DESC));
        result.addOption(OptionBuilder.create((String)"t"));
        return result;
    }

    protected String getOptionString() {
        return "GROUP [SPECIFIC OPTIONS]";
    }

    protected SecurityGroupDescription initGroup(Jec2 jec2) throws Exception {
        String protocol;
        boolean groupSource;
        this.assertNonOptionSet("GROUP");
        String[] sourceGroupUser = this.getOptionValues("source-group-user");
        String[] sourceGroup = this.getOptionValues("source-group");
        String[] sourceSubnet = this.getOptionValues("source-subnet");
        if (sourceGroupUser.length + sourceGroup.length + sourceSubnet.length == 0) {
            sourceSubnet = new String[]{"0.0.0.0/0"};
        }
        boolean cidrSource = sourceSubnet.length > 0;
        boolean bl = groupSource = sourceGroupUser.length + sourceGroup.length > 0;
        if (cidrSource && groupSource) {
            throw new InvalidArgumentCombination("Specify either source groups or source CIDRs, not both.");
        }
        String group = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
        SecurityGroupDescription grp = new SecurityGroupDescription(group, "", "");
        int[] range = new int[]{0, 0};
        int[] icmpTypeCode = new int[]{0, 0};
        if (cidrSource && !this.isOptionSet("protocol")) {
            protocol = "tcp";
        } else if (groupSource && !this.isOptionSet("protocol")) {
            protocol = "all-protocols";
        } else {
            this.assertOptionSet("protocol");
            protocol = this.getOptionValue("protocol");
        }
        if (this.isOptionSet("icmp-type-code")) {
            int code;
            int type;
            String[] parts = this.getOptionValue("icmp-type-code").split(":");
            if (parts.length != 2) {
                throw new InvalidArgument("t", this.getOptionValue("icmp-type-code"));
            }
            try {
                type = Integer.parseInt(parts[0]);
                code = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                throw new InvalidArgument("t", this.getOptionValue("icmp-type-code"));
            }
            icmpTypeCode = new int[]{type, code};
        }
        if (this.isOptionSet("port-range")) {
            range = this.parseRange(this.getOptionValue("port-range"));
        }
        if (!protocol.equals("all-protocols")) {
            if (protocol.equals("icmp")) {
                this.assertOptionSet("icmp-type-code");
                range = icmpTypeCode;
            } else {
                this.assertOptionSet("port-range");
            }
            SecurityGroupDescription.IpPermission perm = grp.addPermission(protocol, range[0], range[1]);
            if (cidrSource) {
                for (int i = 0; i < sourceSubnet.length; ++i) {
                    perm.addIpRange(sourceSubnet[i]);
                }
            } else if (groupSource) {
                this.addSourceGroups(perm, sourceGroupUser, sourceGroup);
            }
        } else {
            if (!groupSource) {
                this.assertOptionSet("port-range");
                this.assertOptionSet("icmp-type-code");
            } else {
                this.assertOptionNotSet("port-range");
                this.assertOptionNotSet("icmp-type-code");
                this.assertOptionNotSet("protocol");
                range = new int[]{0, 65535};
                icmpTypeCode = new int[]{-1, -1};
            }
            SecurityGroupDescription.IpPermission tcpPerm = grp.addPermission("tcp", range[0], range[1]);
            SecurityGroupDescription.IpPermission udpPerm = grp.addPermission("udp", range[0], range[1]);
            SecurityGroupDescription.IpPermission icmpPerm = grp.addPermission("icmp", icmpTypeCode[0], icmpTypeCode[1]);
            if (cidrSource) {
                for (int i = 0; i < sourceSubnet.length; ++i) {
                    tcpPerm.addIpRange(sourceSubnet[i]);
                    udpPerm.addIpRange(sourceSubnet[i]);
                    icmpPerm.addIpRange(sourceSubnet[i]);
                }
            } else if (groupSource) {
                this.addSourceGroups(tcpPerm, sourceGroupUser, sourceGroup);
                this.addSourceGroups(udpPerm, sourceGroupUser, sourceGroup);
                this.addSourceGroups(icmpPerm, sourceGroupUser, sourceGroup);
            }
        }
        return grp;
    }

    private void addSourceGroups(SecurityGroupDescription.IpPermission perm, String[] sourceGroupUser, String[] sourceGroup) {
        for (int i = 0; i < sourceGroup.length; ++i) {
            String user;
            switch (sourceGroupUser.length) {
                case 0: {
                    throw new MissingArgument("source-group-user");
                }
                case 1: {
                    user = sourceGroupUser[0];
                    break;
                }
                default: {
                    if (sourceGroup.length > sourceGroupUser.length) {
                        throw new MissingArgument("source-group");
                    }
                    if (sourceGroup.length < sourceGroupUser.length) {
                        throw new MissingArgument("source-group-user");
                    }
                    user = sourceGroupUser[i];
                }
            }
            perm.addUserGroupPair(user, sourceGroup[i]);
        }
    }

    public void printAuthDescription() {
        super.printDescription();
        System.out.println("     Grant selected permissions to a specified group.");
        System.out.println("     The GROUP parameter is name of the group to grant this permission to.");
    }

    public void printAuthOptions() {
        super.printOptions(true);
        this.printOption("protocol");
        this.printOption("port-range");
        this.printOption("icmp-type-code");
        this.printOption("source-group");
        this.printOption("source-group-user");
        this.printOption("source-subnet");
    }

    public void printRevDescription() {
        super.printDescription();
        System.out.println("     Revoke selected permissions from a specified group.");
        System.out.println("     The GROUP parameter is name of the group to revoke this permission from.");
    }

    public void printRevOptions() {
        super.printOptions(true);
        this.printOption("protocol");
        this.printOption("port-range");
        this.printOption("icmp-type-code");
        this.printOption("source-group");
        this.printOption("source-group-user");
        this.printOption("source-subnet");
    }
}

