/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.DeactivateLicenseResponse;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeactivateLicense
extends BaseCmd {
    private static final String LICENSE_ID_DESC = "The license to deactivate capacity against.";
    private static final String CAPACITY_DESC = "The amount of capacity to deactivate.";

    public DeactivateLicense(String[] args) {
        super("ec2deactlic", "ec2-deactivate-license");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(DeactivateLicense.createOptionWithArgs("c", "capacity", CAPACITY_DESC, "CAPACITY"));
        return result;
    }

    protected String getOptionString() {
        return "LICENSE -c CAPACITY";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Deactivate capacity against a license");
        System.out.println("     The LICENSE parameter is the id of the license to deactivate.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("capacity");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        int capacity;
        this.assertNonOptionSet("LICENSE");
        this.warnIfTooManyNonOptions();
        if (!this.isOptionSet("capacity")) {
            throw new MissingArgument("capacity");
        }
        String licenseId = this.getNonOptions()[0];
        try {
            capacity = Integer.parseInt(this.getOptionValue("capacity"));
        }
        catch (NumberFormatException e) {
            throw new InvalidArgument("capacity", this.getOptionValue("capacity"));
        }
        RequestResultPair rsp = jec2.deactivateLicense(licenseId, capacity);
        if (rsp.getResponse() != null) {
            out.output(System.out, (DeactivateLicenseResponse)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new DeactivateLicense(args).invoke();
    }
}

