/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.TokenWrapper;
import org.apache.ws.security.policy.model.UsernameToken;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class UsernameTokenProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedUsernameToken = false;

    public void initializeUsernameToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.wssUsernameToken10.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wssUsernameToken11.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
    }

    public Object doUsernameToken(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (!this.initializedUsernameToken) {
                    try {
                        this.initializeUsernameToken(spt);
                        UsernameToken unt = (UsernameToken)spc.readCurrentPolicyEngineData();
                        String includetokenUri = spc.getAssertion().getAttribute(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "IncludeToken"));
                        try {
                            if (includetokenUri != null) {
                                unt.setInclusion(includetokenUri);
                            }
                            ((TokenWrapper)((Object)spc.readPreviousPolicyEngineData())).setToken(unt);
                        }
                        catch (WSSPolicyException e) {
                            this.log.error((Object)e.getMessage(), (Throwable)e);
                            return new Boolean(false);
                        }
                        this.initializedUsernameToken = true;
                    }
                    catch (NoSuchMethodException e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                        return new Boolean(false);
                    }
                }
                this.log.debug((Object)spt.getTokenName());
                PrimitiveAssertion pa = spc.getAssertion();
                String text = pa.getStrValue();
                if (text != null) {
                    text = text.trim();
                    this.log.debug((Object)("Value: '" + text.toString() + "'"));
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doWssUsernameToken10(SecurityProcessorContext spc) {
        this.log.debug((Object)"Processing wssUsernameToken10");
        if (spc.getAction() == 1) {
            ((UsernameToken)spc.readCurrentPolicyEngineData()).setUseUTProfile11(false);
        }
        return new Boolean(true);
    }

    public Object doWssUsernameToken11(SecurityProcessorContext spc) {
        this.log.debug((Object)"Processing wssUsernameToken11");
        if (spc.getAction() == 1) {
            ((UsernameToken)spc.readCurrentPolicyEngineData()).setUseUTProfile11(true);
        }
        return new Boolean(true);
    }
}

