/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.accessor.Accessor;
import jd.core.model.classfile.accessor.GetStaticAccessor;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OuterGetStaticVisitor {
    protected Map<String, ClassFile> innerClassesMap;
    protected ConstantPool constants;

    public OuterGetStaticVisitor(HashMap<String, ClassFile> innerClassesMap, ConstantPool constants) {
        this.innerClassesMap = innerClassesMap;
        this.constants = constants;
    }

    public void visit(Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                ArrayLength al = (ArrayLength)instruction;
                Accessor a = this.match(al.arrayref);
                if (a != null) {
                    al.arrayref = this.newInstruction(al.arrayref, a);
                    break;
                }
                this.visit(al.arrayref);
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                Accessor a = this.match(asi.arrayref);
                if (a != null) {
                    asi.arrayref = this.newInstruction(asi.arrayref, a);
                } else {
                    this.visit(asi.arrayref);
                }
                a = this.match(asi.indexref);
                if (a != null) {
                    asi.indexref = this.newInstruction(asi.indexref, a);
                } else {
                    this.visit(asi.indexref);
                }
                a = this.match(asi.valueref);
                if (a != null) {
                    asi.valueref = this.newInstruction(asi.valueref, a);
                    break;
                }
                this.visit(asi.valueref);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                Accessor a = this.match(ai.test);
                if (a != null) {
                    ai.test = this.newInstruction(ai.test, a);
                } else {
                    this.visit(ai.test);
                }
                if (ai.msg == null) break;
                a = this.match(ai.msg);
                if (a != null) {
                    ai.msg = this.newInstruction(ai.msg, a);
                    break;
                }
                this.visit(ai.msg);
                break;
            }
            case 191: {
                AThrow aThrow = (AThrow)instruction;
                Accessor a = this.match(aThrow.value);
                if (a != null) {
                    aThrow.value = this.newInstruction(aThrow.value, a);
                    break;
                }
                this.visit(aThrow.value);
                break;
            }
            case 266: {
                UnaryOperatorInstruction uoi = (UnaryOperatorInstruction)instruction;
                Accessor a = this.match(uoi.value);
                if (a != null) {
                    uoi.value = this.newInstruction(uoi.value, a);
                    break;
                }
                this.visit(uoi.value);
                break;
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                Accessor a = this.match(boi.value1);
                if (a != null) {
                    boi.value1 = this.newInstruction(boi.value1, a);
                } else {
                    this.visit(boi.value1);
                }
                a = this.match(boi.value2);
                if (a != null) {
                    boi.value2 = this.newInstruction(boi.value2, a);
                    break;
                }
                this.visit(boi.value2);
                break;
            }
            case 192: {
                CheckCast checkCast = (CheckCast)instruction;
                Accessor a = this.match(checkCast.objectref);
                if (a != null) {
                    checkCast.objectref = this.newInstruction(checkCast.objectref, a);
                    break;
                }
                this.visit(checkCast.objectref);
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                StoreInstruction storeInstruction = (StoreInstruction)instruction;
                Accessor a = this.match(storeInstruction.valueref);
                if (a != null) {
                    storeInstruction.valueref = this.newInstruction(storeInstruction.valueref, a);
                    break;
                }
                this.visit(storeInstruction.valueref);
                break;
            }
            case 264: {
                DupStore dupStore = (DupStore)instruction;
                Accessor a = this.match(dupStore.objectref);
                if (a != null) {
                    dupStore.objectref = this.newInstruction(dupStore.objectref, a);
                    break;
                }
                this.visit(dupStore.objectref);
                break;
            }
            case 275: 
            case 276: {
                ConvertInstruction ci = (ConvertInstruction)instruction;
                Accessor a = this.match(ci.value);
                if (a != null) {
                    ci.value = this.newInstruction(ci.value, a);
                    break;
                }
                this.visit(ci.value);
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                Accessor a = this.match(ifCmp.value1);
                if (a != null) {
                    ifCmp.value1 = this.newInstruction(ifCmp.value1, a);
                } else {
                    this.visit(ifCmp.value1);
                }
                a = this.match(ifCmp.value2);
                if (a != null) {
                    ifCmp.value2 = this.newInstruction(ifCmp.value2, a);
                    break;
                }
                this.visit(ifCmp.value2);
                break;
            }
            case 260: 
            case 262: {
                IfInstruction iff = (IfInstruction)instruction;
                Accessor a = this.match(iff.value);
                if (a != null) {
                    iff.value = this.newInstruction(iff.value, a);
                    break;
                }
                this.visit(iff.value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    this.visit(branchList.get(i));
                    --i;
                }
                break;
            }
            case 193: {
                InstanceOf instanceOf = (InstanceOf)instruction;
                Accessor a = this.match(instanceOf.objectref);
                if (a != null) {
                    instanceOf.objectref = this.newInstruction(instanceOf.objectref, a);
                    break;
                }
                this.visit(instanceOf.objectref);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                Accessor a = this.match(insi.objectref);
                if (a != null) {
                    insi.objectref = this.newInstruction(insi.objectref, a);
                } else {
                    this.visit(insi.objectref);
                }
            }
            case 184: 
            case 274: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    Accessor a = this.match(list.get(i));
                    if (a != null) {
                        list.set(i, this.newInstruction(list.get(i), a));
                    } else {
                        this.visit(list.get(i));
                    }
                    --i;
                }
                break;
            }
            case 171: {
                LookupSwitch ls = (LookupSwitch)instruction;
                Accessor a = this.match(ls.key);
                if (a != null) {
                    ls.key = this.newInstruction(ls.key, a);
                    break;
                }
                this.visit(ls.key);
                break;
            }
            case 194: {
                MonitorEnter monitorEnter = (MonitorEnter)instruction;
                Accessor a = this.match(monitorEnter.objectref);
                if (a != null) {
                    monitorEnter.objectref = this.newInstruction(monitorEnter.objectref, a);
                    break;
                }
                this.visit(monitorEnter.objectref);
                break;
            }
            case 195: {
                MonitorExit monitorExit = (MonitorExit)instruction;
                Accessor a = this.match(monitorExit.objectref);
                if (a != null) {
                    monitorExit.objectref = this.newInstruction(monitorExit.objectref, a);
                    break;
                }
                this.visit(monitorExit.objectref);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    Accessor a = this.match(dimensions[i]);
                    if (a != null) {
                        dimensions[i] = this.newInstruction(dimensions[i], a);
                    } else {
                        this.visit(dimensions[i]);
                    }
                    --i;
                }
                break;
            }
            case 188: {
                NewArray newArray = (NewArray)instruction;
                Accessor a = this.match(newArray.dimension);
                if (a != null) {
                    newArray.dimension = this.newInstruction(newArray.dimension, a);
                    break;
                }
                this.visit(newArray.dimension);
                break;
            }
            case 189: {
                ANewArray aNewArray = (ANewArray)instruction;
                Accessor a = this.match(aNewArray.dimension);
                if (a != null) {
                    aNewArray.dimension = this.newInstruction(aNewArray.dimension, a);
                    break;
                }
                this.visit(aNewArray.dimension);
                break;
            }
            case 87: {
                Pop pop = (Pop)instruction;
                Accessor a = this.match(pop.objectref);
                if (a != null) {
                    pop.objectref = this.newInstruction(pop.objectref, a);
                    break;
                }
                this.visit(pop.objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                Accessor a = this.match(putField.objectref);
                if (a != null) {
                    putField.objectref = this.newInstruction(putField.objectref, a);
                } else {
                    this.visit(putField.objectref);
                }
                a = this.match(putField.valueref);
                if (a != null) {
                    putField.valueref = this.newInstruction(putField.valueref, a);
                    break;
                }
                this.visit(putField.valueref);
                break;
            }
            case 179: {
                PutStatic putStatic = (PutStatic)instruction;
                Accessor a = this.match(putStatic.valueref);
                if (a != null) {
                    putStatic.valueref = this.newInstruction(putStatic.valueref, a);
                    break;
                }
                this.visit(putStatic.valueref);
                break;
            }
            case 273: {
                ReturnInstruction ri = (ReturnInstruction)instruction;
                Accessor a = this.match(ri.valueref);
                if (a != null) {
                    ri.valueref = this.newInstruction(ri.valueref, a);
                    break;
                }
                this.visit(ri.valueref);
                break;
            }
            case 170: {
                TableSwitch ts = (TableSwitch)instruction;
                Accessor a = this.match(ts.key);
                if (a != null) {
                    ts.key = this.newInstruction(ts.key, a);
                    break;
                }
                this.visit(ts.key);
                break;
            }
            case 280: {
                TernaryOpStore tos = (TernaryOpStore)instruction;
                Accessor a = this.match(tos.objectref);
                if (a != null) {
                    tos.objectref = this.newInstruction(tos.objectref, a);
                    break;
                }
                this.visit(tos.objectref);
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                Accessor a = this.match(to.test);
                if (a != null) {
                    to.test = this.newInstruction(to.test, a);
                } else {
                    this.visit(to.test);
                }
                a = this.match(to.value1);
                if (a != null) {
                    to.value1 = this.newInstruction(to.value1, a);
                } else {
                    this.visit(to.value1);
                }
                a = this.match(to.value2);
                if (a != null) {
                    to.value2 = this.newInstruction(to.value2, a);
                    break;
                }
                this.visit(to.value2);
                break;
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)instruction;
                Accessor a = this.match(ai.value1);
                if (a != null) {
                    ai.value1 = this.newInstruction(ai.value1, a);
                } else {
                    this.visit(ai.value1);
                }
                a = this.match(ai.value2);
                if (a != null) {
                    ai.value2 = this.newInstruction(ai.value2, a);
                    break;
                }
                this.visit(ai.value2);
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                Accessor a = this.match(ali.arrayref);
                if (a != null) {
                    ali.arrayref = this.newInstruction(ali.arrayref, a);
                } else {
                    this.visit(ali.arrayref);
                }
                a = this.match(ali.indexref);
                if (a != null) {
                    ali.indexref = this.newInstruction(ali.indexref, a);
                    break;
                }
                this.visit(ali.indexref);
                break;
            }
            case 277: 
            case 278: {
                IncInstruction ii = (IncInstruction)instruction;
                Accessor a = this.match(ii.value);
                if (a != null) {
                    ii.value = this.newInstruction(ii.value, a);
                    break;
                }
                this.visit(ii.value);
                break;
            }
            case 180: {
                GetField gf = (GetField)instruction;
                Accessor a = this.match(gf.objectref);
                if (a != null) {
                    gf.objectref = this.newInstruction(gf.objectref, a);
                    break;
                }
                this.visit(gf.objectref);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                Accessor a = this.match(iai.newArray);
                if (a != null) {
                    iai.newArray = this.newInstruction(iai.newArray, a);
                } else {
                    this.visit(iai.newArray);
                }
                if (iai.values == null) break;
                this.visit(iai.values);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not replace accessor in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
    }

    public void visit(List<Instruction> instructions) {
        int index = instructions.size() - 1;
        while (index >= 0) {
            Instruction i = instructions.get(index);
            Accessor a = this.match(i);
            if (a != null) {
                instructions.set(index, this.newInstruction(i, a));
            } else {
                this.visit(i);
            }
            --index;
        }
    }

    protected Accessor match(Instruction i) {
        if (i.opcode != 184) {
            return null;
        }
        Invokestatic is = (Invokestatic)i;
        ConstantMethodref cmr = this.constants.getConstantMethodref(is.index);
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.name_and_type_index);
        String descriptor = this.constants.getConstantUtf8(cnat.descriptor_index);
        if (descriptor.charAt(1) != ')') {
            return null;
        }
        String className = this.constants.getConstantClassName(cmr.class_index);
        ClassFile classFile = this.innerClassesMap.get(className);
        if (classFile == null) {
            return null;
        }
        String name = this.constants.getConstantUtf8(cnat.name_index);
        Accessor accessor = classFile.getAccessor(name, descriptor);
        if (accessor == null || accessor.tag != 1) {
            return null;
        }
        return (GetStaticAccessor)accessor;
    }

    protected Instruction newInstruction(Instruction i, Accessor a) {
        GetStaticAccessor gsa = (GetStaticAccessor)a;
        int nameIndex = this.constants.addConstantUtf8(gsa.fieldName);
        int descriptorIndex = this.constants.addConstantUtf8(gsa.fieldDescriptor);
        int cnatIndex = this.constants.addConstantNameAndType(nameIndex, descriptorIndex);
        int classNameIndex = this.constants.addConstantUtf8(gsa.className);
        int classIndex = this.constants.addConstantClass(classNameIndex);
        int cfrIndex = this.constants.addConstantFieldref(classIndex, cnatIndex);
        return new GetStatic(178, i.offset, i.lineNumber, cfrIndex);
    }
}

