/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

public class Square {
    private static final Square[][] POOL = new Square[8][8];
    private final int file;
    private final int rank;

    private Square(int n, int n2) {
        this.file = (byte)n;
        this.rank = (byte)n2;
    }

    public static Square getInstance(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n > 7 || n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("file and rank must be in the range [0-7] (file:" + n + " rank:" + n2 + ")");
        }
        if (POOL[n][n2] == null) {
            Square.POOL[n][n2] = new Square(n, n2);
        }
        return POOL[n][n2];
    }

    public static Square parseSquare(String string) {
        try {
            int n = string.charAt(0) - 97;
            int n2 = string.charAt(1) - 49;
            return Square.getInstance(n, n2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("The given string(" + string + ") does not represent a valid location on a chess board");
        }
    }

    public int getFile() {
        return this.file;
    }

    public int getRank() {
        return this.rank;
    }

    public char getFileChar() {
        return (char)(97 + this.getFile());
    }

    public char getRankChar() {
        return (char)(49 + this.getRank());
    }

    public String toString() {
        char[] cArray = new char[]{this.getFileChar(), this.getRankChar()};
        return new String(cArray);
    }

    public int hashCode() {
        return (this.rank << 3) + this.file;
    }

    public boolean equals(String string) {
        return this == Square.parseSquare(string);
    }

    public boolean equals(int n, int n2) {
        return this == Square.getInstance(n, n2);
    }
}

