/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.I18n;
import free.jin.ui.DialogPanel;
import free.util.TextUtilities;
import free.util.Utilities;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class OptionPanel
extends DialogPanel {
    public static final Object INFO = new String("information");
    public static final Object WARNING = new String("warning");
    public static final Object QUESTION = new String("question");
    public static final Object ERROR = new String("error");
    public static final Object YES = new String("yes");
    public static final Object NO = new String("no");
    public static final Object OK = new String("ok");
    public static final Object CANCEL = new String("cancel");
    private static final Object[] OPTION_ORDER = new Object[]{OK, YES, NO, CANCEL};
    private final Object panelType;
    private final String title;
    private final Object[] options;
    private final Object defaultOption;
    private final Component messageComponent;

    public OptionPanel(Component component, Object object, String string, Object[] objectArray, Object object2, String string2) {
        this.panelType = object;
        this.title = string;
        this.options = objectArray;
        this.defaultOption = object2;
        this.messageComponent = this.createMessageComponent(string2);
        this.setHintParent(component);
        this.createUI();
    }

    public Component createMessageComponent(String string) {
        String[] stringArray = TextUtilities.getTokens(string, "\r\n");
        Box box = Box.createVerticalBox();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            JLabel jLabel = new JLabel(string2);
            box.add(jLabel);
            box.add(Box.createVerticalStrut(2));
        }
        return box;
    }

    public static void error(String string, String string2, Component component) {
        OptionPanel optionPanel = new OptionPanel(component, ERROR, string, new Object[]{OK}, OK, string2);
        optionPanel.display();
    }

    public static void error(String string, String string2) {
        OptionPanel.error(string, string2, null);
    }

    public static Object confirm(Object object, String string, String string2, Component component) {
        OptionPanel optionPanel = new OptionPanel(component, QUESTION, string, new Object[]{OK, CANCEL}, object, string2);
        return optionPanel.display();
    }

    public static Object confirm(String string, String string2, Object object) {
        return OptionPanel.confirm(object, string, string2, null);
    }

    public static Object question(Object object, String string, String string2, Component component) {
        OptionPanel optionPanel = new OptionPanel(component, QUESTION, string, new Object[]{YES, NO}, object, string2);
        return optionPanel.display();
    }

    public static Object question(String string, String string2, Object object) {
        return OptionPanel.question(object, string, string2, null);
    }

    protected String getTitle() {
        return this.title;
    }

    protected Object getCancelResult() {
        return CANCEL;
    }

    private Icon getIcon() {
        if (this.panelType == INFO) {
            return UIManager.getIcon("OptionPane.informationIcon");
        }
        if (this.panelType == WARNING) {
            return UIManager.getIcon("OptionPane.warningIcon");
        }
        if (this.panelType == QUESTION) {
            return UIManager.getIcon("OptionPane.questionIcon");
        }
        if (this.panelType == ERROR) {
            return UIManager.getIcon("OptionPane.errorIcon");
        }
        throw new IllegalArgumentException("Bad panel type: " + this.panelType);
    }

    private void createUI() {
        I18n i18n = I18n.get(OptionPanel.class);
        JPanel jPanel = new JPanel(new FlowLayout(1, 10, 2));
        jPanel.setOpaque(false);
        for (int i = 0; i < OPTION_ORDER.length; ++i) {
            if (!Utilities.contains(this.options, OPTION_ORDER[i])) continue;
            Object object = OPTION_ORDER[i];
            JButton jButton = new JButton(i18n.getString(object.toString() + ".text"));
            jButton.addActionListener(new DialogPanel.ClosingListener(object));
            if (object == this.defaultOption) {
                this.setDefaultButton(jButton);
            }
            jPanel.add(jButton);
        }
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(this.getIcon()));
        box.add(Box.createHorizontalStrut(10));
        box.add(this.messageComponent);
        this.setLayout(new BoxLayout(this, 1));
        this.add(box);
        this.add(Box.createVerticalStrut(15));
        this.add(jPanel);
    }

    public Object display() {
        return super.askResult();
    }
}

