/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mlf.metouia.borders;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sourceforge.mlf.metouia.borders.MetouiaButtonBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaTextFieldBorder;
import net.sourceforge.mlf.metouia.borders.MetouiaToggleButtonBorder;

public class MetouiaBorderUtilities {
    private static Border buttonBorder;
    private static Border textBorder;
    private static Border textFieldBorder;
    private static Border toggleButtonBorder;

    static void drawSimple3DBorder(Graphics graphics, Rectangle rectangle) {
        MetouiaBorderUtilities.drawSimple3DBorder(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static void drawSimple3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        MetouiaBorderUtilities.drawSimple3DBorder(graphics, n, n2, n3, n4, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow());
    }

    static void drawPressed3DBorder(Graphics graphics, Rectangle rectangle) {
        MetouiaBorderUtilities.drawPressed3DBorder(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawDisabledBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        MetouiaBorderUtilities.drawSimple3DBorder(graphics, n, n2, n3, n4, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlShadow());
    }

    static void drawPressed3DBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        MetouiaBorderUtilities.drawSimple3DBorder(graphics, n, n2, n3, n4, MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControlHighlight());
    }

    public static final void drawSimple3DBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n3 - 2, 0);
        graphics.drawLine(0, 1, 0, n4 - 1);
        graphics.setColor(color2);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 2);
        graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
        graphics.translate(-n, -n2);
    }

    public static final void drawBevel3DBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4) {
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n3 - 2, 0);
        graphics.drawLine(0, 1, 0, n4 - 1);
        graphics.setColor(color2);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 2);
        graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
        ++n;
        ++n2;
        graphics.setColor(color3);
        graphics.drawLine(0, 0, --n3 - 2, 0);
        graphics.drawLine(0, 1, 0, --n4 - 1);
        graphics.setColor(color4);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 2);
        graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
        graphics.translate(-n, -n2);
    }

    static void drawPressed3DFieldBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        graphics.setColor(MetalLookAndFeel.getControlHighlight());
        graphics.drawRect(1, 1, n3 - 2, n4 - 2);
        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
        graphics.drawRect(0, 0, n3 - 2, n4 - 2);
        graphics.translate(-n, -n2);
    }

    static void drawDefaultButtonBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        MetouiaBorderUtilities.drawSimple3DBorder(graphics, n + 1, n2 + 1, n3 - 2, n4 - 2, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlShadow());
        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new MetouiaButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border getTextBorder() {
        if (textBorder == null) {
            textBorder = new BorderUIResource.CompoundBorderUIResource(new MetouiaTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new MetouiaTextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new MetouiaToggleButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    public static Border getDesktopIconBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new LineBorder(MetalLookAndFeel.getControlDarkShadow(), 1), new MatteBorder(2, 2, 1, 2, MetalLookAndFeel.getControl()));
    }
}

