/*
 * Decompiled with CFR 0.152.
 */
package free.chessclub.level2;

import free.util.FormatException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class Datagram {
    public static final char DG_DELIM = '\u0019';
    private static final char DG_START = '(';
    private static final char DG_END = ')';
    public static final int DG_WHO_AM_I = 0;
    public static final int DG_PLAYER_ARRIVED = 1;
    public static final int DG_PLAYER_LEFT = 2;
    public static final int DG_BULLET = 3;
    public static final int DG_BLITZ = 4;
    public static final int DG_STANDARD = 5;
    public static final int DG_WILD = 6;
    public static final int DG_BUGHOUSE = 7;
    public static final int DG_TIMESTAMP = 8;
    public static final int DG_TITLES = 9;
    public static final int DG_OPEN = 10;
    public static final int DG_STATE = 11;
    public static final int DG_GAME_STARTED = 12;
    public static final int DG_GAME_RESULT = 13;
    public static final int DG_EXAMINED_GAME_IS_GONE = 14;
    public static final int DG_MY_GAME_STARTED = 15;
    public static final int DG_MY_GAME_RESULT = 16;
    public static final int DG_MY_GAME_ENDED = 17;
    public static final int DG_STARTED_OBSERVING = 18;
    public static final int DG_STOP_OBSERVING = 19;
    public static final int DG_PLAYERS_IN_MY_GAME = 20;
    public static final int DG_OFFERS_IN_MY_GAME = 21;
    public static final int DG_TAKEBACK = 22;
    public static final int DG_BACKWARD = 23;
    public static final int DG_SEND_MOVES = 24;
    public static final int DG_MOVE_LIST = 25;
    public static final int DG_KIBITZ = 26;
    public static final int DG_PEOPLE_IN_MY_CHANNEL = 27;
    public static final int DG_CHANNEL_TELL = 28;
    public static final int DG_MATCH = 29;
    public static final int DG_MATCH_REMOVED = 30;
    public static final int DG_PERSONAL_TELL = 31;
    public static final int DG_SHOUT = 32;
    public static final int DG_MOVE_ALGEBRAIC = 33;
    public static final int DG_MOVE_SMITH = 34;
    public static final int DG_MOVE_TIME = 35;
    public static final int DG_MOVE_CLOCK = 36;
    public static final int DG_BUGHOUSE_HOLDINGS = 37;
    public static final int DG_SET_CLOCK = 38;
    public static final int DG_FLIP = 39;
    public static final int DG_ISOLATED_BOARD = 40;
    public static final int DG_REFRESH = 41;
    public static final int DG_ILLEGAL_MOVE = 42;
    public static final int DG_MY_RELATION_TO_GAME = 43;
    public static final int DG_PARTNERSHIP = 44;
    public static final int DG_SEES_SHOUTS = 45;
    public static final int DG_CHANNELS_SHARED = 46;
    public static final int DG_MY_VARIABLE = 47;
    public static final int DG_MY_STRING_VARIABLE = 48;
    public static final int DG_JBOARD = 49;
    public static final int DG_SEEK = 50;
    public static final int DG_SEEK_REMOVED = 51;
    public static final int DG_MY_RATING = 52;
    public static final int DG_SOUND = 53;
    public static final int DG_PLAYER_ARRIVED_SIMPLE = 55;
    public static final int DG_MSEC = 56;
    public static final int DG_BUGHOUSE_PASS = 57;
    public static final int DG_IP = 58;
    public static final int DG_CIRCLE = 59;
    public static final int DG_ARROW = 60;
    public static final int DG_MORETIME = 61;
    public static final int DG_PERSONAL_TELL_ECHO = 62;
    public static final int DG_SUGGESTION = 63;
    public static final int DG_NOTIFY_ARRIVED = 64;
    public static final int DG_NOTIFY_LEFT = 65;
    public static final int DG_NOTIFY_OPEN = 66;
    public static final int DG_NOTIFY_STATE = 67;
    public static final int DG_MY_NOTIFY_LIST = 68;
    public static final int DG_LOGIN_FAILED = 69;
    public static final int DG_FEN = 70;
    public static final int DG_TOURNEY_MATCH = 71;
    public static final int DG_GAMELIST_BEGIN = 72;
    public static final int DG_GAMELIST_ITEM = 73;
    public static final int DG_IDLE = 74;
    public static final int DG_ACK_PING = 75;
    public static final int DG_RATING_TYPE_KEY = 76;
    public static final int DG_GAME_MESSAGE = 77;
    public static final int DG_UNACCENTED = 78;
    public static final int DG_STRINGLIST_BEGIN = 79;
    public static final int DG_STRINGLIST_ITEM = 80;
    public static final int DG_DUMMY_RESPONSE = 81;
    public static final int DG_CHANNEL_QTELL = 82;
    public static final int DG_PERSONAL_QTELL = 83;
    public static final int DG_SET_BOARD = 84;
    public static final int DG_MATCH_ASSESSMENT = 85;
    public static final int DG_LOG_PGN = 86;
    public static final int DG_NEW_MY_RATING = 87;
    public static final int DG_LOSERS = 88;
    public static final int DG_UNCIRCLE = 89;
    public static final int DG_UNARROW = 90;
    public static final int DG_WSUGGEST = 91;
    public static final int DG_TEMPORARY_PASSWORD = 93;
    public static final int DG_MESSAGELIST_BEGIN = 94;
    public static final int DG_MESSAGELIST_ITEM = 95;
    public static final int DG_LIST = 96;
    public static final int DG_SJI_AD = 97;
    public static final int DG_RETRACT = 99;
    public static final int DG_MY_GAME_CHANGE = 100;
    public static final int DG_POSITION_BEGIN = 101;
    public static final int DG_TOURNEY = 103;
    public static final int DG_REMOVE_TOURNEY = 104;
    public static final int DG_DIALOG_START = 105;
    public static final int DG_DIALOG_DATA = 106;
    public static final int DG_DIALOG_DEFAULT = 107;
    public static final int DG_DIALOG_END = 108;
    public static final int DG_DIALOG_RELEASE = 109;
    public static final int DG_POSITION_BEGIN2 = 110;
    public static final int DG_PAST_MOVE = 111;
    public static final int DG_PGN_TAG = 112;
    public static final int DG_IS_VARIATION = 113;
    public static final int DG_PASSWORD = 114;
    public static final int DG_WILD_KEY = 116;
    public static final int DG_SET2 = 124;
    public static final int DG_KNOWS_FISCHER_RANDOM = 132;
    public static final int MAX_DG_ID = 132;
    private final int id;
    private final String[] fields;

    public Datagram(int n, String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Datagram fields may not be null");
        }
        this.id = n;
        this.fields = stringArray;
    }

    public int getId() {
        return this.id;
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public String getField(int n) {
        return this.fields[n];
    }

    public String getString(int n) {
        return this.getField(n);
    }

    public int getInteger(int n) {
        return Integer.parseInt(this.getField(n));
    }

    public long getLong(int n) {
        return Long.parseLong(this.getField(n));
    }

    public boolean getBoolean(int n) {
        return this.getField(n).equals("1");
    }

    public static Datagram readDatagram(InputStream inputStream) throws IOException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n2;
            if ((n2 = inputStream.read()) < 0) {
                throw new EOFException();
            }
            if (n2 == 41 && n > 1 && stringBuffer.charAt(n - 1) == '\u0019') {
                stringBuffer.append((char)n2);
                return Datagram.parseDatagram(stringBuffer.toString());
            }
            stringBuffer.append((char)n2);
            ++n;
        }
    }

    public static Datagram parseDatagram(String string) throws FormatException {
        try {
            int n = string.length();
            if (n < 2 || string.charAt(0) != '\u0019' || string.charAt(1) != '(') {
                throw new FormatException("dgString does not start with \"^Y(\": " + string);
            }
            if (n < 2 || string.charAt(n - 2) != '\u0019' || string.charAt(n - 1) != ')') {
                throw new FormatException("dgString does not end with \"^Y)\": " + string);
            }
            string = string.substring(2, string.length() - 2) + " ";
            int n2 = string.indexOf(32);
            int n3 = Integer.parseInt(string.substring(0, n2));
            Vector<String> vector = new Vector<String>();
            ++n2;
            int n4 = string.length();
            while (n2 < n4) {
                int n5;
                int n6;
                char c = string.charAt(n2);
                if (c == '{') {
                    n6 = n2 + 1;
                    n5 = string.indexOf(125, n6);
                    n2 = n5 + 2;
                } else if (c == '\u0019') {
                    n6 = n2 + 2;
                    n5 = string.indexOf(25, n6);
                    n2 = n5 + 3;
                } else {
                    while (c == ' ') {
                        c = string.charAt(++n2);
                    }
                    n6 = n2;
                    n5 = string.indexOf(32, n6);
                    n2 = n5 + 1;
                }
                vector.addElement(string.substring(n6, n5));
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return new Datagram(n3, (String[])objectArray);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException((Throwable)numberFormatException);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new FormatException((Throwable)stringIndexOutOfBoundsException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Datagram ID=" + this.getId() + " Fields: ");
        int n = this.getFieldCount();
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append("{" + this.getField(i) + "}");
            stringBuffer.append(",");
        }
        stringBuffer.append("{" + this.getField(n - 1) + "}");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

