/*
 * Decompiled with CFR 0.152.
 */
package com.cheusov;

import com.cheusov.Directories;
import com.cheusov.JrepMatchResult;
import com.cheusov.JrepOptionsGroups;
import com.cheusov.JrepPattern;
import com.cheusov.Opts;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Jrep {
    private static final JrepOptionsGroups optionsGroups = new JrepOptionsGroups();
    private static int exitStatus = 1;
    private static final String[] stdinFilenames = new String[]{"-"};
    private static final Pattern patternSpaces = Pattern.compile("\\p{IsWhiteSpace}+");
    private static final Pattern patternSpacesBeg = Pattern.compile("^\\p{IsWhiteSpace}+");
    private static final Pattern patternSpacesEnd = Pattern.compile("\\p{IsWhiteSpace}+$");

    private static void println(String line) {
        if (!Opts.opt_q) {
            System.out.println(line);
            if (Opts.opt_line_buffered) {
                System.out.flush();
            }
        }
    }

    private static void printlnWithPrefix(String filename, String line, int lineNumber, char separator) {
        String prefix1 = "";
        if (Opts.prefixWithFilename) {
            prefix1 = filename + separator;
        }
        String prefix = prefix1;
        if (Opts.opt_n) {
            prefix = prefix + lineNumber + separator;
        }
        Jrep.println(prefix + line);
    }

    private static String getLineToPrint(String line, List<Pair<Integer, Integer>> startend) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(startend, new Comparator<Pair<Integer, Integer>>(){

            @Override
            public int compare(Pair<Integer, Integer> a, Pair<Integer, Integer> b) {
                if (a.getLeft() < b.getLeft()) {
                    return -1;
                }
                if (a.getLeft() > b.getLeft()) {
                    return 1;
                }
                return b.getRight() - a.getRight();
            }
        });
        int prev = 0;
        for (Pair<Integer, Integer> p : startend) {
            int start = p.getLeft();
            int end = p.getRight();
            if (end < prev) continue;
            if (start < prev) {
                start = prev;
            }
            sb.append(line.substring(prev, start));
            if (start < end) {
                sb.append(Opts.colorEscStart);
                sb.append(line.substring(start, end));
                sb.append(Opts.colorEscEnd);
            }
            prev = end;
        }
        return sb.toString() + line.substring(prev);
    }

    private static StringBuilder[] extractCurlyBraces(String text, int pos) {
        char c;
        StringBuilder[] ret = new StringBuilder[]{null, null};
        StringBuilder sbLetters = ret[0] = new StringBuilder();
        StringBuilder sbDigits = ret[1] = new StringBuilder();
        int length = text.length();
        while (pos < length && (c = text.charAt(pos)) != '}') {
            if (c >= '0' && c <= '9') {
                sbDigits.append(c);
            } else {
                sbLetters.append(c);
            }
            ++pos;
        }
        return ret;
    }

    private static String getGroup(JrepMatchResult match, int groupNum) {
        String value = match.group(groupNum);
        if (value == null) {
            return "";
        }
        return value;
    }

    private static String getOutputString(String line, JrepMatchResult match, String filename) {
        if (Opts.opt_O == null) {
            return line.substring(match.start(), match.end());
        }
        StringBuilder b = new StringBuilder();
        int len = Opts.opt_O.length();
        for (int i = 0; i < len; ++i) {
            char c = Opts.opt_O.charAt(i);
            if (c != '$') {
                b.append(c);
                continue;
            }
            if (i + 1 == len) {
                throw new IllegalArgumentException("Unexpected `$` in -O argument: `" + Opts.opt_O + "`");
            }
            char nc = Opts.opt_O.charAt(i + 1);
            String value = "";
            CharSequence l = "";
            if (nc == '{') {
                StringBuilder[] ld = Jrep.extractCurlyBraces(Opts.opt_O, ++i + 1);
                l = ld[0];
                StringBuilder d = ld[1];
                i += d.length() + l.length();
                if (d.length() > 0) {
                    nc = '\u0000';
                    int groupNum = Integer.valueOf(d.toString());
                    value = Jrep.getGroup(match, groupNum);
                }
                if (d.length() == 0 && l.length() > 0) {
                    nc = l.charAt(0);
                    l = l.subSequence(1, l.length());
                }
            }
            ++i;
            switch (nc) {
                case '\u0000': {
                    break;
                }
                case 'f': {
                    value = filename;
                    break;
                }
                case '<': {
                    value = Opts.colorEscStart;
                    break;
                }
                case '>': {
                    value = Opts.colorEscEnd;
                    break;
                }
                case '$': {
                    value = "$";
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = Jrep.getGroup(match, nc - 48);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal `$" + nc + "` in -O argument: `" + Opts.opt_O + "`");
                }
            }
            block19: for (int j = 0; j < l.length(); ++j) {
                char lc = l.charAt(j);
                switch (lc) {
                    case 'n': {
                        value = value.replaceAll("\\\\", "\\\\\\\\").replaceAll("\n", "\\\\n");
                        continue block19;
                    }
                    case 'N': {
                        value = value.replaceAll("\n", " ");
                        continue block19;
                    }
                    case 's': {
                        value = patternSpaces.matcher(value).replaceAll(" ");
                        continue block19;
                    }
                    case 't': {
                        value = patternSpacesBeg.matcher(value).replaceFirst("");
                        value = patternSpacesEnd.matcher(value).replaceFirst("");
                        continue block19;
                    }
                    case 'b': {
                        value = new File(value).getName();
                        continue block19;
                    }
                    case 'e': {
                        value = value.replaceFirst("[.][^.]+$", "");
                        continue block19;
                    }
                    case 'c': {
                        value = StringEscapeUtils.escapeCsv(value);
                        continue block19;
                    }
                    case 'C': {
                        value = "\"" + value.replaceAll("\"", "\"\"") + "\"";
                        continue block19;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected modifier `" + lc + "' in -O argument");
                    }
                }
            }
            b.append(value);
        }
        return b.toString();
    }

    private static void processFile(InputStream in, String filename) throws IOException {
        Iterator<String> it;
        if (Opts.wholeContent) {
            String fileContent = IOUtils.toString(in, Opts.encoding);
            it = Arrays.asList(fileContent).iterator();
        } else {
            it = IOUtils.lineIterator(in, Opts.encoding);
        }
        int matchCount = 0;
        ArrayList<Pair<Integer, Integer>> startend = null;
        int lineNumber = 0;
        int lastMatchedLineNumber = 0;
        HashMap<Integer, String> lines = new HashMap<Integer, String>();
        while (it.hasNext()) {
            ++lineNumber;
            String line = it.next();
            if (Opts.opt_B > 0) {
                lines.put(lineNumber, line);
                lines.remove(lineNumber - Opts.opt_B - 1);
            }
            boolean matched = false;
            boolean nextFile = false;
            if (!(Opts.inverseMatch || Opts.outputFilename || Opts.opt_o || Opts.opt_L || Opts.opt_c)) {
                startend = new ArrayList<Pair<Integer, Integer>>();
            }
            String lineToPrint = null;
            block1: for (JrepPattern pattern : Opts.patterns) {
                int pos = 0;
                JrepMatchResult m = pattern.matcher(line);
                int lineLength = line.length();
                while (pos < lineLength && m.find(pos)) {
                    matched = true;
                    if (Opts.outputFilename || Opts.opt_c || Opts.opt_L || Opts.inverseMatch) continue block1;
                    if (Opts.opt_o) {
                        Jrep.printlnWithPrefix(filename, Jrep.getOutputString(line, m, filename), lineNumber, ':');
                    } else if (Opts.colorEscStart != null) {
                        startend.add(Pair.of(m.start(), m.end()));
                    }
                    pos = m.end();
                    if (m.start() != m.end()) continue;
                    ++pos;
                }
            }
            if (matched ^= Opts.inverseMatch) {
                if (exitStatus == 1) {
                    exitStatus = 0;
                }
                if (!(Opts.outputFilename || Opts.opt_o || Opts.opt_L || Opts.opt_c)) {
                    lineToPrint = Opts.colorEscStart == null || startend == null ? line : Jrep.getLineToPrint(line, startend);
                }
                if (Opts.outputFilename) {
                    Jrep.println(filename);
                    nextFile = true;
                }
            }
            if (lineToPrint != null) {
                for (int prevLineNumber = lineNumber - Opts.opt_B; prevLineNumber < lineNumber; ++prevLineNumber) {
                    String prevLine = (String)lines.get(prevLineNumber);
                    if (prevLine == null) continue;
                    lines.remove(prevLineNumber);
                    Jrep.printlnWithPrefix(filename, prevLine, prevLineNumber, '-');
                }
                lastMatchedLineNumber = lineNumber;
                lines.remove(lineNumber);
                Jrep.printlnWithPrefix(filename, lineToPrint, lineNumber, ':');
            } else if (lastMatchedLineNumber > 0 && lastMatchedLineNumber + Opts.opt_A >= lineNumber) {
                lines.remove(lineNumber);
                Jrep.printlnWithPrefix(filename, line, lineNumber, '-');
            }
            if (matched && ++matchCount == Opts.opt_m) {
                nextFile = true;
            }
            if (!nextFile) continue;
            break;
        }
        if (Opts.opt_L && matchCount == 0) {
            Jrep.println(filename);
        }
        if (Opts.opt_c) {
            Jrep.printlnWithPrefix(filename, "" + matchCount, lineNumber, ':');
        }
    }

    private static void grep(String[] args) throws Exception {
        if (args.length == 0) {
            args = stdinFilenames;
        }
        for (String fileOrDir : args) {
            try {
                Iterator<Object> fileIterator;
                File file = new File(fileOrDir);
                boolean isDir = false;
                if (Opts.opt_directories != Directories.READ) {
                    isDir = file.isDirectory();
                }
                if (isDir && Opts.opt_directories == Directories.SKIP) continue;
                if (isDir && Opts.opt_directories == Directories.RECURSE) {
                    if (!Opts.orIncludeDirFilter.accept(file)) continue;
                    fileIterator = FileUtils.iterateFiles(file, Opts.fileFilter, Opts.orIncludeDirFilter);
                } else {
                    fileIterator = Arrays.asList(fileOrDir).iterator();
                }
                while (fileIterator.hasNext()) {
                    Object fileObj = fileIterator.next();
                    String filename = fileObj instanceof String ? (String)fileObj : ((File)fileObj).getPath().replaceAll("^^[.]/", "");
                    if (filename.equals("-")) {
                        Jrep.processFile(System.in, Opts.label);
                        continue;
                    }
                    if (!Opts.fileFilter.accept(new File(filename))) continue;
                    FileInputStream in = new FileInputStream(filename);
                    Jrep.processFile(in, filename);
                    in.close();
                }
            }
            catch (IOException e) {
                if (!Opts.opt_s) {
                    System.err.println(e.toString());
                }
                exitStatus = 2;
            }
        }
    }

    public static void main(String[] args) {
        try {
            args = Opts.init(optionsGroups, args);
            Jrep.grep(args);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            exitStatus = 2;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            exitStatus = 2;
        }
        System.exit(exitStatus);
    }
}

