/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.kafka.trogdor.common.Topology;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.RoundTripWorker;

public class RoundTripWorkloadSpec
extends TaskSpec {
    private final String clientNode;
    private final String bootstrapServers;
    private final int targetMessagesPerSec;
    private final NavigableMap<Integer, List<Integer>> partitionAssignments;
    private final int maxMessages;

    @JsonCreator
    public RoundTripWorkloadSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="clientNode") String clientNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="targetMessagesPerSec") int targetMessagesPerSec, @JsonProperty(value="partitionAssignments") NavigableMap<Integer, List<Integer>> partitionAssignments, @JsonProperty(value="maxMessages") int maxMessages) {
        super(startMs, durationMs);
        this.clientNode = clientNode;
        this.bootstrapServers = bootstrapServers;
        this.targetMessagesPerSec = targetMessagesPerSec;
        this.partitionAssignments = partitionAssignments;
        this.maxMessages = maxMessages;
    }

    @JsonProperty
    public String clientNode() {
        return this.clientNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public int targetMessagesPerSec() {
        return this.targetMessagesPerSec;
    }

    @JsonProperty
    public NavigableMap<Integer, List<Integer>> partitionAssignments() {
        return this.partitionAssignments;
    }

    @JsonProperty
    public int maxMessages() {
        return this.maxMessages;
    }

    @Override
    public TaskController newController(String id) {
        return new TaskController(){

            @Override
            public Set<String> targetNodes(Topology topology) {
                return Collections.singleton(RoundTripWorkloadSpec.this.clientNode);
            }
        };
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new RoundTripWorker(id, this);
    }
}

