<?PHP // queue.php

    include("config.php");

    if ($mode) {
        $meta = "<META HTTP-EQUIV=refresh CONTENT=\"20;URL=queue.php?mode=$mode\">\n";
    } else {
        $meta = "<META HTTP-EQUIV=refresh CONTENT=\"20;URL=queue.php\">\n";
    }

    print_header($meta);

    if (isset($album)) {
        if (isset($track)) {
            if (isset($command) && $command == "unqueue") {
                $result = unqueue($album, $track);
            } else {
                $result = queue($album, $track);
            }
        } else {
            $result = queue($album);
        }
    }

    if (isset($filter)) {
        $result = filter($filter);
    } 

    $queue = queue();

    if (!isset($mode)) {
        if ($queue["QUEUECOUNT"] > 0) {
            $mode = "queue";
        } else {
            $mode = "top";
        }
    }

    if ($mode == "queue") {
        print_heading("Queue ... <A HREF=\"queue.php?mode=top\">Random</A> ... 
                       <A HREF=\"queue.php?mode=history\">History</A>", 
                      "image/refresh.gif", "queue.php?mode=queue", "Refresh");
   
        if ($queue["QUEUECOUNT"] == 0) {
            echo "<H3 ALIGN=CENTER>Queue is empty</H3>";
            die;
        }
        echo "<TABLE BORDER=0 WIDTH=100%>";

        for ($i=0; $i < $queue["QUEUECOUNT"]; $i++) {
            $track = $queue[$i];
            $albumnum = $track["ALBUM_NO"];
            $tracknum = $track["TRACK_NO"];
            echo "<TR VALIGN=top>";
            echo "<TD><A TARGET=\"mp3tracks\" HREF=\"tracks.php?album=$albumnum&track=$tracknum\">".$track["TRACK"]."</A>";
            echo "<TD>".$track["ARTIST"];
            echo "<TD WIDTH=10>".$track["RATING"];
            echo "<TD WIDTH=40 ALIGN=right><A TITLE=\"Unqueue this track\" TARGET=\"mp3queue\" HREF=\"queue.php?command=unqueue&album=$albumnum&track=$tracknum\"><IMG SRC=image/sub.gif BORDER=0 HEIGHT=15 WIDTH=15></A>";
            echo "</TR>";
        }
        echo "</TABLE>";

    } else if ($mode == "top") {
        print_heading("<A HREF=\"queue.php?mode=queue\">Queue</A> ... Random ... 
                       <A HREF=\"queue.php?mode=history\">History</A>", 
                      "image/refresh.gif", "queue.php?mode=top", "Refresh");

        $top = top();

        echo "<TABLE BORDER=0 WIDTH=100%>";

        for ($i=0; $i < $top["TOPCOUNT"]; $i++) {
            $track = $top[$i];
            $albumnum = $track["ALBUM_NO"];
            $tracknum = $track["TRACK_NO"];
            echo "<TR VALIGN=top>";
            //echo "<TD>".$track["PROB"];
            echo "<TD><A TITLE=\"Probability factor: ".$track["PROB"]."\" TARGET=\"mp3tracks\" HREF=\"tracks.php?album=$albumnum&track=$tracknum\">".$track["TRACK"]."</A>";
            echo "<TD>".$track["ARTIST"];
            echo "<TD WIDTH=10>".$track["RATING"];
            echo "<TD WIDTH=40 ALIGN=right><A TITLE=\"Queue this track\" TARGET=\"mp3queue\" HREF=\"queue.php?album=$albumnum&track=$tracknum\"><IMG SRC=\"image/add.gif\" BORDER=0 HEIGHT=15 WIDTH=15></A>";
            echo "</TR>";
        }
        echo "</TABLE>";

    } else { // mode = history
        print_heading("<A HREF=\"queue.php?mode=queue\">Queue</A> ... <A HREF=\"queue.php?mode=top\">Random</A> ... 
                       History", 
                      "image/refresh.gif", "queue.php?mode=history", "Refresh");

        $history = history();
        echo "<TABLE BORDER=0 WIDTH=100%>";
        for ($i=0; $i < $history["HISTORYCOUNT"]; $i++) {
            $track = $history[$i];
            $albumnum = $track["ALBUM_NO"];
            $tracknum = $track["TRACK_NO"];
            echo "<TR VALIGN=top>";
            echo "<TD><A TARGET=\"mp3tracks\" HREF=\"tracks.php?album=$albumnum&track=$tracknum\">".$track["TRACK"]."</A>";
            echo "<TD>".$track["ARTIST"];
            echo "<TD>".$track["USER"];
            echo "<TD WIDTH=40 ALIGN=right><A TITLE=\"Queue this track\" TARGET=\"mp3queue\" HREF=\"queue.php?album=$albumnum&track=$tracknum\"><IMG SRC=\"image/add.gif\" BORDER=0 HEIGHT=15 WIDTH=15></A>";
            echo "</TR>";
        }
        echo "</TABLE>";
    }


?>

