/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Definitions
implements Serializable {
    private static final long serialVersionUID = 1191703801007779489L;
    private final Map<Integer, LineTagMap> line_maps;
    private final Map<String, Set<Integer>> symbols = new HashMap<String, Set<Integer>>();
    private final List<Tag> tags;

    public Definitions() {
        this.line_maps = new HashMap<Integer, LineTagMap>();
        this.tags = new ArrayList<Tag>();
    }

    public Set<String> getSymbols() {
        return this.symbols.keySet();
    }

    public boolean hasSymbol(String symbol) {
        return this.symbols.containsKey(symbol);
    }

    public boolean hasDefinitionAt(String symbol, int lineNumber, String[] strs) {
        Set<Integer> lines = this.symbols.get(symbol);
        if (strs.length > 0) {
            strs[0] = "none";
        }
        if (lines != null && lines.contains(lineNumber)) {
            Iterator iterator;
            LineTagMap line_map = this.line_maps.get(lineNumber);
            if (line_map != null && (iterator = ((Set)line_map.sym_tags.get(symbol)).iterator()).hasNext()) {
                Tag tag = (Tag)iterator.next();
                if (strs.length > 0) {
                    strs[0] = tag.type;
                }
            }
            return true;
        }
        return false;
    }

    public int occurrences(String symbol) {
        Set<Integer> lines = this.symbols.get(symbol);
        return lines == null ? 0 : lines.size();
    }

    public int numberOfSymbols() {
        return this.symbols.size();
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void addTag(int line, String symbol, String type, String text) {
        HashSet<Tag> tags;
        Tag new_tag = new Tag(line, symbol, type, text);
        this.tags.add(new_tag);
        Set<Integer> lines = this.symbols.get(symbol);
        if (lines == null) {
            lines = new HashSet<Integer>();
            this.symbols.put(symbol, lines);
        }
        Integer aLine = line;
        lines.add(aLine);
        LineTagMap line_map = this.line_maps.get(aLine);
        if (line_map == null) {
            line_map = new LineTagMap();
            this.line_maps.put(aLine, line_map);
        }
        if ((tags = (HashSet<Tag>)line_map.sym_tags.get(symbol)) == null) {
            tags = new HashSet<Tag>();
            line_map.sym_tags.put(symbol, tags);
        }
        tags.add(new_tag);
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        new ObjectOutputStream(bytes).writeObject(this);
        return bytes.toByteArray();
    }

    public static Definitions deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return (Definitions)in.readObject();
    }

    public static class Tag
    implements Serializable {
        private static final long serialVersionUID = 1217869075425651464L;
        public final int line;
        public final String symbol;
        public final String type;
        public final String text;

        protected Tag(int line, String symbol, String type, String text) {
            this.line = line;
            this.symbol = symbol;
            this.type = type;
            this.text = text;
        }
    }

    public static class LineTagMap
    implements Serializable {
        private static final long serialVersionUID = 1191703801007779481L;
        private final Map<String, Set<Tag>> sym_tags = new HashMap<String, Set<Tag>>();

        protected LineTagMap() {
        }
    }
}

