/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.index;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Filter
implements Serializable {
    private static final long serialVersionUID = 3L;
    private final Set<String> filename = new HashSet<String>();
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private final List<String> path = new ArrayList<String>();
    private final List<String> items = new PatternList(this);

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setItems(List<String> item) {
        this.clear();
        for (String s : item) {
            this.add(s);
        }
    }

    public void add(String pattern) {
        if (!this.items.contains(pattern)) {
            this.items.add(pattern);
        }
    }

    public void clear() {
        this.patterns.clear();
        this.filename.clear();
        this.path.clear();
        this.items.clear();
    }

    public boolean match(File file) {
        String fileExtension;
        int start;
        boolean ret = false;
        String fileName = file.getName();
        String absolute = file.getAbsolutePath();
        if (this.filename.contains(fileName)) {
            ret = true;
        } else {
            for (Pattern p : this.patterns) {
                Matcher m = p.matcher(fileName);
                if (m.matches()) {
                    ret = true;
                    break;
                }
                if (!p.pattern().contains("/") || !(m = p.matcher(absolute)).matches()) continue;
                ret = true;
                break;
            }
        }
        if (!ret) {
            for (String s : this.path) {
                if (!absolute.endsWith(s)) continue;
                ret = true;
                break;
            }
        }
        if (!ret && (start = fileName.indexOf(".")) != -1 && this.filename.contains(fileExtension = fileName.substring(start, fileName.length()))) {
            ret = true;
        }
        return ret;
    }

    public boolean match(String name) {
        return this.match(new File(name));
    }

    private void addPattern(String pattern) {
        if (pattern.contains("*") || pattern.contains("?")) {
            this.patterns.add(this.compilePattern(pattern));
        } else if (pattern.contains(File.separator)) {
            if (pattern.charAt(0) == File.separatorChar) {
                this.path.add(pattern);
            } else {
                this.path.add(File.separator + pattern);
            }
        } else {
            this.filename.add(pattern);
        }
    }

    private Pattern compilePattern(String pattern) {
        String[] components;
        StringBuilder regex = new StringBuilder();
        int pos = 0;
        for (String str : components = pattern.split("[*?]")) {
            if (str.length() > 0) {
                regex.append(Pattern.quote(str));
                pos += str.length();
            }
            if (pos >= pattern.length()) continue;
            if (pattern.charAt(pos) == '*') {
                regex.append(".*");
            } else {
                assert (pattern.charAt(pos) == '?');
                regex.append('.');
            }
            ++pos;
        }
        return Pattern.compile(regex.toString());
    }

    public static class PatternList
    extends ArrayList<String> {
        private final Filter owner;

        public PatternList(Filter owner) {
            this.owner = owner;
        }

        @Override
        public boolean add(String pattern) {
            boolean ret = super.add(pattern);
            if (ret) {
                this.owner.addPattern(pattern);
            }
            return ret;
        }
    }
}

