/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.management;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.Configuration;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.management.JMXConfigurationMBean;
import org.opensolaris.opengrok.management.Management;

public class JMXConfiguration
implements JMXConfigurationMBean {
    @Override
    public String getConfiguration() {
        return RuntimeEnvironment.getInstance().getConfiguration().getXMLRepresentationAsString();
    }

    @Override
    public void setConfiguration(String config) throws IOException {
        Configuration configuration = Configuration.makeXMLStringAsConfiguration(config);
        RuntimeEnvironment.getInstance().setConfiguration(configuration);
        String configfile = Management.getInstance().getConfigurationFile();
        try {
            File file = new File(configfile);
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException("Could not create configuration file: '" + configfile + "'");
            }
            RuntimeEnvironment.getInstance().writeConfiguration(file);
        }
        catch (IOException orig) {
            IOException ioex = new IOException("Could not create configuration file " + configfile);
            ioex.initCause(orig);
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Could not create configfile " + configfile, ioex);
            throw ioex;
        }
    }
}

