/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.commons.jrcs.diff.DiffAlgorithm;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.myers.MyersDiff;
import org.apache.commons.jrcs.util.ToString;

public class Diff
extends ToString {
    public static final String NL = System.getProperty("line.separator");
    public static final String RCS_EOL = "\n";
    protected final Object[] orig;
    protected DiffAlgorithm algorithm;

    public Diff(Object[] objectArray) {
        this(objectArray, null);
    }

    public Diff(Object[] objectArray, DiffAlgorithm diffAlgorithm) {
        if (objectArray == null) {
            throw new IllegalArgumentException();
        }
        this.orig = objectArray;
        this.algorithm = diffAlgorithm != null ? diffAlgorithm : this.defaultAlgorithm();
    }

    protected DiffAlgorithm defaultAlgorithm() {
        return new MyersDiff();
    }

    public static Revision diff(Object[] objectArray, Object[] objectArray2) throws DifferentiationFailedException {
        if (objectArray == null || objectArray2 == null) {
            throw new IllegalArgumentException();
        }
        return Diff.diff(objectArray, objectArray2, null);
    }

    public static Revision diff(Object[] objectArray, Object[] objectArray2, DiffAlgorithm diffAlgorithm) throws DifferentiationFailedException {
        if (objectArray == null || objectArray2 == null) {
            throw new IllegalArgumentException();
        }
        return new Diff(objectArray, diffAlgorithm).diff(objectArray2);
    }

    public Revision diff(Object[] objectArray) throws DifferentiationFailedException {
        if (this.orig.length == 0 && objectArray.length == 0) {
            return new Revision();
        }
        return this.algorithm.diff(this.orig, objectArray);
    }

    public static boolean compare(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static String arrayToString(Object[] objectArray) {
        return Diff.arrayToString(objectArray, NL);
    }

    public static Object[] editAll(Object[] objectArray) {
        Object[] objectArray2 = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i] + " <edited>";
        }
        return objectArray2;
    }

    public static Object[] randomEdit(Object[] objectArray) {
        return Diff.randomEdit(objectArray, objectArray.length);
    }

    public static Object[] randomEdit(Object[] objectArray, long l) {
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
        Random random = new Random(l);
        int n = random.nextInt(10);
        for (int i = 0; i < n; ++i) {
            boolean bl = random.nextBoolean();
            int n2 = random.nextInt(arrayList.size() + 1);
            int n3 = Math.min(arrayList.size() - n2, 1 + random.nextInt(4));
            if (bl && arrayList.size() > 0) {
                arrayList.subList(n2, n2 + n3).clear();
                continue;
            }
            int n4 = 0;
            while (n4 < n3) {
                arrayList.add(n2, "[" + i + "] random edit[" + i + "][" + i + "]");
                ++n4;
                ++n2;
            }
        }
        return arrayList.toArray();
    }

    public static Object[] shuffle(Object[] objectArray) {
        return Diff.shuffle(objectArray, objectArray.length);
    }

    public static Object[] shuffle(Object[] objectArray, long l) {
        ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
        Collections.shuffle(arrayList);
        return arrayList.toArray();
    }

    public static Object[] randomSequence(int n) {
        return Diff.randomSequence(n, n);
    }

    public static Object[] randomSequence(int n, long l) {
        Object[] objectArray = new Integer[n];
        Random random = new Random(l);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new Integer(random.nextInt(n));
        }
        return objectArray;
    }
}

