/*
 * Decompiled with CFR 0.152.
 */
package com.concurrent_ruby.ext;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import sun.misc.Unsafe;

public class SynchronizationLibrary
implements Library {
    private static final Unsafe UNSAFE = SynchronizationLibrary.loadUnsafe();
    private static final boolean FULL_FENCE = SynchronizationLibrary.supportsFences();
    private static final ObjectAllocator JRUBY_OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JRubyObject(ruby, rubyClass);
        }
    };
    private static final ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Object(ruby, rubyClass);
        }
    };
    private static final ObjectAllocator ABSTRACT_LOCKABLE_OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new AbstractLockableObject(ruby, rubyClass);
        }
    };
    private static final ObjectAllocator JRUBY_LOCKABLE_OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JRubyLockableObject(ruby, rubyClass);
        }
    };

    private static Unsafe loadUnsafe() {
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Exception exception) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    private static boolean supportsFences() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Method method = UNSAFE.getClass().getDeclaredMethod("fullFence", new Class[0]);
            if (method != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void load(Ruby ruby, boolean bl) throws IOException {
        RubyModule rubyModule = ruby.defineModule("Concurrent").defineModuleUnder("Synchronization");
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("JRubyAttrVolatile");
        rubyModule2.defineAnnotatedMethods(JRubyAttrVolatile.class);
        this.defineClass(ruby, rubyModule, "AbstractObject", "JRubyObject", JRubyObject.class, JRUBY_OBJECT_ALLOCATOR);
        this.defineClass(ruby, rubyModule, "JRubyObject", "Object", Object.class, OBJECT_ALLOCATOR);
        this.defineClass(ruby, rubyModule, "Object", "AbstractLockableObject", AbstractLockableObject.class, ABSTRACT_LOCKABLE_OBJECT_ALLOCATOR);
        this.defineClass(ruby, rubyModule, "AbstractLockableObject", "JRubyLockableObject", JRubyLockableObject.class, JRUBY_LOCKABLE_OBJECT_ALLOCATOR);
        this.defineClass(ruby, rubyModule, "Object", "JRuby", JRuby.class, new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new JRuby(ruby, rubyClass);
            }
        });
    }

    private RubyClass defineClass(Ruby ruby, RubyModule rubyModule, String string, String string2, Class clazz, ObjectAllocator objectAllocator) {
        RubyClass rubyClass = rubyModule.getClass(string);
        if (rubyClass == null) {
            System.out.println("not found " + string);
            throw ruby.newRuntimeError(rubyModule.toString() + "::" + string + " is missing");
        }
        RubyClass rubyClass2 = rubyModule.defineClassUnder(string2, rubyClass, objectAllocator);
        rubyClass2.defineAnnotatedMethods(clazz);
        return rubyClass2;
    }

    public static class JRubyAttrVolatile {
        private static volatile int volatileField;

        @JRubyMethod(name={"full_memory_barrier"}, visibility=Visibility.PUBLIC)
        public static IRubyObject fullMemoryBarrier(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (!FULL_FENCE) {
                int n = volatileField;
                volatileField = threadContext.getLine();
            } else {
                UNSAFE.fullFence();
            }
            return threadContext.nil;
        }

        @JRubyMethod(name={"instance_variable_get_volatile"}, visibility=Visibility.PUBLIC)
        public static IRubyObject instanceVariableGetVolatile(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (!FULL_FENCE) {
                int n = volatileField;
                return ((RubyBasicObject)iRubyObject).instance_variable_get(threadContext, iRubyObject2);
            }
            UNSAFE.loadFence();
            return ((RubyBasicObject)iRubyObject).instance_variable_get(threadContext, iRubyObject2);
        }

        @JRubyMethod(name={"instance_variable_set_volatile"}, visibility=Visibility.PUBLIC)
        public static IRubyObject InstanceVariableSetVolatile(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            if (!FULL_FENCE) {
                IRubyObject iRubyObject4 = ((RubyBasicObject)iRubyObject).instance_variable_set(iRubyObject2, iRubyObject3);
                volatileField = threadContext.getLine();
                return iRubyObject4;
            }
            return ((RubyBasicObject)iRubyObject).instance_variable_set(iRubyObject2, iRubyObject3);
        }
    }

    @JRubyClass(name={"JRubyObject"}, parent="AbstractObject")
    public static class JRubyObject
    extends RubyObject {
        public JRubyObject(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }
    }

    @JRubyClass(name={"Object"}, parent="JRubyObject")
    public static class Object
    extends JRubyObject {
        public Object(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }
    }

    @JRubyClass(name={"AbstractLockableObject"}, parent="Object")
    public static class AbstractLockableObject
    extends Object {
        public AbstractLockableObject(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }
    }

    @JRubyClass(name={"JRubyLockableObject"}, parent="AbstractLockableObject")
    public static class JRubyLockableObject
    extends JRubyObject {
        public JRubyLockableObject(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"synchronize"}, visibility=Visibility.PROTECTED)
        public IRubyObject rubySynchronize(ThreadContext threadContext, Block block) {
            JRubyLockableObject jRubyLockableObject = this;
            synchronized (jRubyLockableObject) {
                return block.yield(threadContext, null);
            }
        }

        @JRubyMethod(name={"ns_wait"}, optional=1, visibility=Visibility.PROTECTED)
        public IRubyObject nsWait(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
            Ruby ruby = threadContext.runtime;
            if (iRubyObjectArray.length > 1) {
                throw ruby.newArgumentError(iRubyObjectArray.length, 1);
            }
            Double d = null;
            if (iRubyObjectArray.length > 0 && !iRubyObjectArray[0].isNil() && (d = Double.valueOf(iRubyObjectArray[0].convertToFloat().getDoubleValue())) < 0.0) {
                throw ruby.newArgumentError("time interval must be positive");
            }
            if (Thread.interrupted()) {
                throw ruby.newConcurrencyError("thread interrupted");
            }
            boolean bl = false;
            try {
                bl = threadContext.getThread().wait_timeout((IRubyObject)this, d);
            }
            catch (InterruptedException interruptedException) {
                throw ruby.newConcurrencyError(interruptedException.getLocalizedMessage());
            }
            finally {
                if (!bl) {
                    ((java.lang.Object)((java.lang.Object)this)).notify();
                }
            }
            return this;
        }

        @JRubyMethod(name={"ns_signal"}, visibility=Visibility.PROTECTED)
        public IRubyObject nsSignal(ThreadContext threadContext) {
            ((java.lang.Object)((java.lang.Object)this)).notify();
            return this;
        }

        @JRubyMethod(name={"ns_broadcast"}, visibility=Visibility.PROTECTED)
        public IRubyObject nsBroadcast(ThreadContext threadContext) {
            ((java.lang.Object)((java.lang.Object)this)).notifyAll();
            return this;
        }
    }

    @JRubyClass(name={"JRuby"})
    public static class JRuby
    extends RubyObject {
        public JRuby(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod(name={"sleep_interruptibly"}, visibility=Visibility.PUBLIC, module=true)
        public static IRubyObject sleepInterruptibly(final ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
            try {
                threadContext.getThread().executeBlockingTask(new RubyThread.BlockingTask(){

                    public void run() throws InterruptedException {
                        block.call(threadContext);
                    }

                    public void wakeup() {
                        threadContext.getThread().getNativeThread().interrupt();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw threadContext.runtime.newThreadError("interrupted in Concurrent::Synchronization::JRuby.sleep_interruptibly");
            }
            return threadContext.nil;
        }
    }
}

