/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.CallbackInfo;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.utils.FBUtilities;

public class WriteCallbackInfo
extends CallbackInfo {
    private final Object mutation;

    public WriteCallbackInfo(InetAddress target, IAsyncCallback callback, MessageOut message, IVersionedSerializer<?> serializer, ConsistencyLevel consistencyLevel, boolean allowHints) {
        super(target, callback, serializer, true);
        assert (message != null);
        this.mutation = WriteCallbackInfo.shouldHint(allowHints, message, consistencyLevel);
        assert (!target.equals(FBUtilities.getBroadcastAddress()));
    }

    @Override
    public boolean shouldHint() {
        return this.mutation != null && StorageProxy.shouldHint(this.target);
    }

    public Mutation mutation() {
        return WriteCallbackInfo.getMutation(this.mutation);
    }

    private static Mutation getMutation(Object object) {
        assert (object instanceof Commit || object instanceof Mutation) : object;
        return object instanceof Commit ? ((Commit)object).makeMutation() : (Mutation)object;
    }

    private static Object shouldHint(boolean allowHints, MessageOut sentMessage, ConsistencyLevel consistencyLevel) {
        return allowHints && sentMessage.verb != MessagingService.Verb.COUNTER_MUTATION && consistencyLevel != ConsistencyLevel.ANY ? sentMessage.payload : null;
    }
}

