/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromIds;
import vcf.GeneticMap;
import vcf.Marker;

public class PositionMap
implements GeneticMap {
    private final double scaleFactor;

    public double scaleFactor() {
        return this.scaleFactor;
    }

    public PositionMap(double d) {
        if (!Double.isFinite(d) || d <= 0.0) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        this.scaleFactor = d;
    }

    @Override
    public int basePos(int n, double d) {
        if (n < 0 || n >= ChromIds.instance().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        long l = Math.round(d / this.scaleFactor);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.valueOf(l));
        }
        return (int)l;
    }

    @Override
    public double genPos(Marker marker) {
        return this.scaleFactor * (double)marker.pos();
    }

    @Override
    public double genPos(int n, int n2) {
        if (n < 0 || n >= ChromIds.instance().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.scaleFactor * (double)n2;
    }
}

