/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.server;

import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NegotiatingServerConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ALPNServerConnection
extends NegotiatingServerConnection
implements ALPN.ServerProvider {
    private static final Logger LOG = Log.getLogger(ALPNServerConnection.class);

    public ALPNServerConnection(Connector connector, EndPoint endPoint, SSLEngine engine, List<String> protocols, String defaultProtocol) {
        super(connector, endPoint, engine, protocols, defaultProtocol);
        ALPN.put((SSLEngine)engine, (ALPN.Provider)this);
    }

    public void unsupported() {
        this.select(Collections.emptyList());
    }

    public String select(List<String> clientProtocols) {
        List serverProtocols = this.getProtocols();
        String negotiated = null;
        for (String serverProtocol : serverProtocols) {
            if (!clientProtocols.contains(serverProtocol)) continue;
            negotiated = serverProtocol;
            break;
        }
        if (negotiated == null) {
            negotiated = this.getDefaultProtocol();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} protocol selected {}", new Object[]{this, negotiated});
        }
        this.setProtocol(negotiated);
        ALPN.remove((SSLEngine)this.getSSLEngine());
        return negotiated;
    }

    public void close() {
        ALPN.remove((SSLEngine)this.getSSLEngine());
        super.close();
    }
}

