/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.util.EnumMap;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.BeginRequestContentParser;
import org.eclipse.jetty.fcgi.parser.ContentParser;
import org.eclipse.jetty.fcgi.parser.ParamsContentParser;
import org.eclipse.jetty.fcgi.parser.Parser;
import org.eclipse.jetty.fcgi.parser.StreamContentParser;

public class ServerParser
extends Parser {
    private final EnumMap<FCGI.FrameType, ContentParser> contentParsers = new EnumMap(FCGI.FrameType.class);

    public ServerParser(Listener listener) {
        this.contentParsers.put(FCGI.FrameType.BEGIN_REQUEST, new BeginRequestContentParser(this.headerParser, listener));
        this.contentParsers.put(FCGI.FrameType.PARAMS, new ParamsContentParser(this.headerParser, listener));
        this.contentParsers.put(FCGI.FrameType.STDIN, new StreamContentParser(this.headerParser, FCGI.StreamType.STD_IN, listener));
    }

    @Override
    protected ContentParser findContentParser(FCGI.FrameType frameType) {
        return this.contentParsers.get((Object)frameType);
    }

    public static interface Listener
    extends Parser.Listener {
        public void onStart(int var1, FCGI.Role var2, int var3);

        public static class Adapter
        extends Parser.Listener.Adapter
        implements Listener {
            @Override
            public void onStart(int request, FCGI.Role role, int flags) {
            }
        }
    }
}

