/*
 * Decompiled with CFR 0.152.
 */
package free.chess.variants.atomic;

import free.chess.ChessMove;
import free.chess.ChessPiece;
import free.chess.ChesslikeGenericVariant;
import free.chess.Move;
import free.chess.Position;
import free.chess.Square;

public class Atomic
extends ChesslikeGenericVariant {
    private static final Atomic INSTANCE = new Atomic();

    public static Atomic getInstance() {
        return INSTANCE;
    }

    private Atomic() {
        super("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1", "Atomic");
    }

    public void makeMove(Move move, Position position, Position.Modifier modifier) {
        this.checkPosition(position);
        if (!(move instanceof ChessMove)) {
            throw new IllegalArgumentException("Wrong piece type: " + move.getClass());
        }
        ChessMove chessMove = (ChessMove)move;
        Square square = chessMove.getEndingSquare();
        super.makeMove(chessMove, position, modifier);
        if (chessMove.isCapture()) {
            this.clearSquare(square.getFile() + 1, square.getRank() + 1, position, modifier);
            this.clearSquare(square.getFile() + 1, square.getRank(), position, modifier);
            this.clearSquare(square.getFile() + 1, square.getRank() - 1, position, modifier);
            this.clearSquare(square.getFile(), square.getRank() + 1, position, modifier);
            this.clearSquare(square.getFile(), square.getRank() - 1, position, modifier);
            this.clearSquare(square.getFile() - 1, square.getRank() + 1, position, modifier);
            this.clearSquare(square.getFile() - 1, square.getRank(), position, modifier);
            this.clearSquare(square.getFile() - 1, square.getRank() - 1, position, modifier);
            modifier.setPieceAt(null, square);
        }
    }

    private void clearSquare(int n, int n2, Position position, Position.Modifier modifier) {
        if (n < 0 || n > 7 || n2 < 0 || n2 > 7) {
            return;
        }
        Square square = Square.getInstance(n, n2);
        ChessPiece chessPiece = (ChessPiece)position.getPieceAt(square);
        if (chessPiece != null && !chessPiece.isPawn()) {
            modifier.setPieceAt(null, square);
        }
    }
}

