/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.ExtensionFilenameFilter;
import free.util.IOUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class ApplyLicense {
    public static void main(String[] stringArray) {
        String string;
        int n;
        if (stringArray.length < 3) {
            if (stringArray.length != 0) {
                System.out.println("Not enough arguments.");
            }
            ApplyLicense.printUsage();
            System.exit(0);
        }
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        for (n = 0; n < stringArray.length - 3; ++n) {
            string = stringArray[n];
            if (string.equals("-r")) {
                bl = true;
                continue;
            }
            if (string.equals("-b")) {
                string2 = stringArray[++n];
                continue;
            }
            if (!string.equals("-u")) continue;
            bl2 = true;
        }
        if (n > stringArray.length - 3) {
            System.out.println("Not enough arguments");
            ApplyLicense.printUsage();
            System.exit(0);
        }
        string = stringArray[stringArray.length - 3];
        String string3 = stringArray[stringArray.length - 2];
        String string4 = stringArray[stringArray.length - 1];
        File file = string2 == null ? null : new File(string2);
        File file2 = new File(string);
        File file3 = new File(string4);
        if (!file2.exists()) {
            System.out.println("No such file: " + string);
            System.exit(0);
        }
        if (!file3.exists()) {
            System.out.println("No such directory: " + string4);
            System.exit(0);
        }
        if (!file3.isDirectory()) {
            System.out.println(string4 + " is a file, not a directory");
            System.exit(0);
        }
        if (file != null) {
            if (!file.exists()) {
                System.out.print("Creating backup directory " + string2 + " ");
                if (!file.mkdirs()) {
                    System.out.println("Unable to create backup directory " + string2);
                    System.exit(0);
                }
                System.out.println("done");
            }
            try {
                System.out.print("Backing up files in " + file.getCanonicalPath() + " ");
                IOUtilities.copyDir(file3, file, bl);
                System.out.println("done");
            }
            catch (IOException iOException) {
                System.out.println("Unable to backup files into " + string2);
                iOException.printStackTrace();
                System.exit(0);
            }
        }
        try {
            String string5 = IOUtilities.loadTextFile(file2);
            if (bl2) {
                ApplyLicense.removeLicense(string5, new ExtensionFilenameFilter("." + string3), file3, bl);
            } else {
                ApplyLicense.applyLicense(string5, new ExtensionFilenameFilter("." + string3), file3, bl);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(0);
        }
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("ApplyLicense Utility");
        System.out.println("Copyright (C) 2001 Alexander Maryanovsky");
        System.out.println();
        System.out.println("Use: java free.util.ApplyLicense [-r][-b backupDir] licenseFile extension dir");
        System.out.println();
        System.out.println("-r              Apply recursively into subdirectories");
        System.out.println("-u              Undo applying the license");
        System.out.println("-b backupDir    Backup files into the given directory before applying license");
        System.out.println();
        System.out.println("Version 1.00 - 05 Oct. 2001");
    }

    public static void applyLicense(String string, FilenameFilter filenameFilter, File file, boolean bl) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("The directory " + file + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file.toString() + " is a file, not a directory");
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            File file2 = new File(file, string2);
            if (file2.isDirectory()) {
                if (!bl) continue;
                ApplyLicense.applyLicense(string, filenameFilter, file2, true);
                continue;
            }
            if (!filenameFilter.accept(file, string2)) continue;
            System.out.print("Prepending license text to: " + file2);
            ApplyLicense.prependLicense(string, file2);
            System.out.println(" done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prependLicense(String string, File file) throws IOException {
        File file2 = new File(file.getAbsolutePath() + ".tmp");
        if (!file.renameTo(file2)) {
            throw new IOException("Unable to rename " + file + " into " + file2);
        }
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            bufferedWriter.write(string);
            ((Writer)bufferedWriter).flush();
            inputStream = new FileInputStream(file2);
            IOUtilities.pump(inputStream, fileOutputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        if (!file2.delete()) {
            throw new IOException("Unable to delete " + file2);
        }
    }

    public static void removeLicense(String string, FilenameFilter filenameFilter, File file, boolean bl) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("The directory " + file + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file.toString() + " is a file, not a directory");
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            File file2 = new File(file, string2);
            if (file2.isDirectory()) {
                if (!bl) continue;
                ApplyLicense.removeLicense(string, filenameFilter, file2, true);
                continue;
            }
            if (!filenameFilter.accept(file, string2)) continue;
            System.out.print("Removing license text from: " + file2);
            ApplyLicense.deleteLicense(string, file2);
            System.out.println(" done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean deleteLicense(String string, File file) throws IOException {
        File file2 = new File(file.getAbsolutePath() + ".tmp");
        if (!file.renameTo(file2)) {
            throw new IOException("Unable to rename " + file + " into " + file2);
        }
        OutputStream outputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
            int n = 0;
            while (n < string.length()) {
                int n2 = ((InputStream)fileInputStream).read();
                if (n2 != -1 && (byte)n2 == string.charAt(n++)) continue;
                ((InputStream)fileInputStream).close();
                fileInputStream = null;
                if (!file2.renameTo(file)) {
                    throw new IOException("Unable to rename " + file2 + " into " + file);
                }
                boolean bl = false;
                return bl;
            }
            outputStream = new FileOutputStream(file);
            IOUtilities.pump(fileInputStream, outputStream);
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        if (!file2.delete()) {
            throw new IOException("Unable to delete " + file2);
        }
        return true;
    }
}

