/*
 * Decompiled with CFR 0.152.
 */
package free.util.swing;

import free.util.Localization;
import free.util.WindowDisposingListener;
import free.util.swing.LocalizationService;
import free.util.swing.SwingUtils;
import free.workarounds.FixedJTextArea;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class PlainTextDialog
extends JDialog {
    private final String title;
    private final JTextArea textArea;
    private final JButton closeButton;

    public PlainTextDialog(Component component, String string, String string2) {
        super(SwingUtils.frameForComponent(component), string == null ? "" : string, true);
        this.title = string;
        this.setDefaultCloseOperation(2);
        SwingUtils.registerEscapeCloser(this);
        this.textArea = new FixedJTextArea(string2, 20, 81);
        Localization localization = LocalizationService.getForClass(PlainTextDialog.class);
        this.closeButton = new JButton(localization.getString("closeButton.text"));
        this.createUI();
    }

    public void setTextAreaFont(Font font) {
        this.textArea.setFont(font);
    }

    protected void createUI() {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.setContentPane(jPanel);
        if (this.title != null) {
            jComponent = new JLabel(this.title, 0);
            jComponent.setAlignmentX(0.5f);
            jComponent.setFont(new Font("Serif", 0, 36));
            jPanel.add(jComponent);
            jPanel.add(Box.createVerticalStrut(10));
        }
        jPanel.add(Box.createVerticalStrut(10));
        this.textArea.setRequestFocusEnabled(false);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        jComponent = new JScrollPane(this.textArea);
        jPanel.add(jComponent);
        jPanel.add(Box.createVerticalStrut(20));
        this.closeButton.addActionListener(new WindowDisposingListener(this));
        this.closeButton.setAlignmentX(0.5f);
        this.getRootPane().setDefaultButton(this.closeButton);
        jPanel.add(this.closeButton);
    }
}

