/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.jin.Jin;
import free.jin.ui.OptionPanel;
import free.util.AWTUtilities;
import free.util.Localization;
import free.util.Pair;
import free.util.Utilities;
import free.util.swing.ColorChooser;
import free.util.swing.PlainTextDialog;
import free.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Font;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class I18n {
    private static final Map cache = new HashMap();
    private final Localization localization;
    private final String className;
    private final I18n parent;

    private I18n(Class clazz, Locale locale, I18n i18n) {
        this.localization = Localization.load(clazz, locale);
        this.className = Utilities.getClassName(clazz);
        this.parent = i18n;
    }

    private I18n(Class clazz, Locale locale) {
        this(clazz, locale, null);
    }

    public static I18n get(Class clazz) {
        I18n i18n = (I18n)cache.get(clazz);
        if (i18n == null) {
            i18n = new I18n(clazz, Jin.getInstance().getLocale());
            cache.put(clazz, i18n);
        }
        return i18n;
    }

    public static I18n get(Class clazz, Class clazz2) {
        if (clazz.equals(clazz2)) {
            return I18n.get(clazz);
        }
        Pair pair = new Pair(clazz, clazz2);
        I18n i18n = (I18n)cache.get(pair);
        if (i18n == null) {
            i18n = new I18n(clazz, Jin.getInstance().getLocale(), I18n.get(clazz.getSuperclass(), clazz2));
            cache.put(pair, i18n);
        }
        return i18n;
    }

    public String getString(String string) throws MissingResourceException {
        String string2 = this.getString(string, null);
        if (string2 != null) {
            return string2;
        }
        throw new MissingResourceException("Missing i18n resource \"" + string + "\" for class " + this.className, this.className, string);
    }

    public String getString(String string, String string2) {
        String string3 = null;
        if (this.localization != null) {
            string3 = this.localization.getString(string);
        }
        if (string3 != null) {
            return string3;
        }
        return this.parent == null ? string2 : this.parent.getString(string, string2);
    }

    public String getFormattedString(String string, Object[] objectArray) throws MissingResourceException {
        return I18n.formatMessage(this.getString(string), objectArray);
    }

    public int getInt(String string) throws MissingResourceException {
        return Integer.parseInt(this.getString(string));
    }

    public int getInt(String string, int n) {
        String string2 = this.getString(string, null);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    private static String formatMessage(String string, Object[] objectArray) {
        return objectArray == null ? string : MessageFormat.format(string, objectArray);
    }

    public JLabel createLabel(String string) {
        JLabel jLabel = new JLabel();
        SwingUtils.applyLabelSpec(jLabel, this.getString(string + ".text"));
        return jLabel;
    }

    public JRadioButton createRadioButton(String string) {
        return (JRadioButton)this.initAbstractButton(new JRadioButton(), string);
    }

    public JCheckBox createCheckBox(String string) {
        return (JCheckBox)this.initAbstractButton(new JCheckBox(), string);
    }

    public JButton createButton(String string) {
        return (JButton)this.initAbstractButton(new JButton(), string);
    }

    public JMenuItem createMenuItem(String string) {
        return this.createMenuItem(string, null);
    }

    public JMenuItem createMenuItem(String string, Object[] objectArray) {
        JMenuItem jMenuItem = new JMenuItem();
        String string2 = this.getString(string + ".text");
        string2 = I18n.formatMessage(string2, objectArray);
        SwingUtils.applyLabelSpec(jMenuItem, string2);
        return jMenuItem;
    }

    public ColorChooser createColorChooser(String string) {
        ColorChooser colorChooser = new ColorChooser();
        SwingUtils.applyLabelSpec(colorChooser, this.getString(string + ".text"));
        colorChooser.setToolTipText(this.getString(string + ".tooltip", null));
        return colorChooser;
    }

    public AbstractButton initAbstractButton(AbstractButton abstractButton, String string) {
        SwingUtils.applyLabelSpec(abstractButton, this.getString(string + ".text"));
        abstractButton.setToolTipText(this.getString(string + ".tooltip", null));
        return abstractButton;
    }

    public TitledBorder createTitledBorder(String string) {
        String string2 = this.getString(string + ".title");
        return BorderFactory.createTitledBorder(string2);
    }

    private String getOptionPanelTitle(String string) {
        return this.getString(string + ".title");
    }

    private String getOptionPanelMessage(String string, Object[] objectArray) {
        String string2 = this.getString(string + ".message");
        if (objectArray != null) {
            string2 = I18n.formatMessage(string2, objectArray);
        }
        return string2;
    }

    public void error(String string, Component component, Object[] objectArray) {
        String string2 = this.getOptionPanelTitle(string);
        String string3 = this.getOptionPanelMessage(string, objectArray);
        OptionPanel.error(string2, string3, component);
    }

    public void error(String string, Component component) {
        this.error(string, component, null);
    }

    public void error(String string, Object[] objectArray) {
        this.error(string, null, objectArray);
    }

    public void error(String string) {
        this.error(string, null, null);
    }

    public Object confirm(Object object, String string, Component component, Object[] objectArray) {
        String string2 = this.getOptionPanelTitle(string);
        String string3 = this.getOptionPanelMessage(string, objectArray);
        return OptionPanel.confirm(object, string2, string3, component);
    }

    public Object confirm(Object object, String string, Component component) {
        return this.confirm(object, string, component, null);
    }

    public Object confirm(Object object, String string, Object[] objectArray) {
        return this.confirm(object, string, null, objectArray);
    }

    public Object confirm(Object object, String string) {
        return this.confirm(object, string, null, null);
    }

    public Object question(Object object, String string, Component component, Object[] objectArray) {
        String string2 = this.getOptionPanelTitle(string);
        String string3 = this.getOptionPanelMessage(string, objectArray);
        return OptionPanel.question(object, string2, string3, component);
    }

    public Object question(Object object, String string, Component component) {
        return this.question(object, string, component, null);
    }

    public Object question(Object object, String string, Object[] objectArray) {
        return this.question(object, string, null, objectArray);
    }

    public Object question(Object object, String string) {
        return this.question(object, string, null, null);
    }

    public void showPlainTextDialog(String string, Component component) {
        String string2 = this.getString(string + ".title");
        String string3 = this.getString(string + ".message");
        PlainTextDialog plainTextDialog = new PlainTextDialog(component, string2, string3);
        plainTextDialog.setTextAreaFont(new Font("Monospaced", 0, 12));
        AWTUtilities.centerWindow(plainTextDialog, component);
        plainTextDialog.setVisible(true);
    }
}

