/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDependencyFinder {
    public static final ExtensionPointName<FileDependencyFinder> EP_NAME = ExtensionPointName.create((String)"com.intellij.plugins.watcher.dependency.finder");
    private static final QueueProcessor<Runnable> QUEUE_PROCESSOR = QueueProcessor.createRunnableQueueProcessor((QueueProcessor.ThreadToUse)QueueProcessor.ThreadToUse.POOLED);

    public abstract boolean accept(@Nullable String var1);

    public boolean trackAllDependentFiles() {
        return true;
    }

    public boolean updateGeneratedFilesOfDependencies() {
        return false;
    }

    @NotNull
    public Set<VirtualFile> findDependentFiles(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            FileDependencyFinder.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            FileDependencyFinder.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            FileDependencyFinder.$$$reportNull$$$0(2);
        }
        if (DumbService.isDumb((Project)project)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FileDependencyFinder.$$$reportNull$$$0(3);
            }
            return set;
        }
        if (!virtualFile.isValid()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FileDependencyFinder.$$$reportNull$$$0(4);
            }
            return set;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                FileDependencyFinder.$$$reportNull$$$0(5);
            }
            return set;
        }
        THashSet result = new THashSet();
        FileIncludeManager.getManager((Project)project).processIncludingFiles(psiFile, arg_0 -> FileDependencyFinder.lambda$findDependentFiles$0(scope, (Set)result, arg_0));
        THashSet tHashSet = result;
        if (tHashSet == null) {
            FileDependencyFinder.$$$reportNull$$$0(6);
        }
        return tHashSet;
    }

    public void findDependenciesAsync(@NotNull Project project, @NotNull VirtualFile file, @NotNull GlobalSearchScope scope, boolean recursively, @NotNull Consumer<Set<VirtualFile>> dependenciesConsumer) {
        if (project == null) {
            FileDependencyFinder.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FileDependencyFinder.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            FileDependencyFinder.$$$reportNull$$$0(9);
        }
        if (dependenciesConsumer == null) {
            FileDependencyFinder.$$$reportNull$$$0(10);
        }
        DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            if (project == null) {
                FileDependencyFinder.$$$reportNull$$$0(11);
            }
            if (file == null) {
                FileDependencyFinder.$$$reportNull$$$0(12);
            }
            if (dependenciesConsumer == null) {
                FileDependencyFinder.$$$reportNull$$$0(13);
            }
            if (scope == null) {
                FileDependencyFinder.$$$reportNull$$$0(14);
            }
            QUEUE_PROCESSOR.add(() -> {
                if (project == null) {
                    FileDependencyFinder.$$$reportNull$$$0(15);
                }
                if (file == null) {
                    FileDependencyFinder.$$$reportNull$$$0(16);
                }
                if (dependenciesConsumer == null) {
                    FileDependencyFinder.$$$reportNull$$$0(17);
                }
                if (scope == null) {
                    FileDependencyFinder.$$$reportNull$$$0(18);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (project == null) {
                        FileDependencyFinder.$$$reportNull$$$0(19);
                    }
                    if (file == null) {
                        FileDependencyFinder.$$$reportNull$$$0(20);
                    }
                    if (dependenciesConsumer == null) {
                        FileDependencyFinder.$$$reportNull$$$0(21);
                    }
                    if (scope == null) {
                        FileDependencyFinder.$$$reportNull$$$0(22);
                    }
                    if (project.isDisposed() || !file.isValid()) {
                        dependenciesConsumer.consume(Collections.emptySet());
                        return;
                    }
                    VirtualFile[] dependencyArray = FileIncludeManager.getManager((Project)project).getIncludedFiles(file, true, recursively);
                    if (dependencyArray == null || dependencyArray.length == 0) {
                        dependenciesConsumer.consume(Collections.emptySet());
                        return;
                    }
                    THashSet result = new THashSet(dependencyArray.length);
                    for (VirtualFile dependency : dependencyArray) {
                        if (!scope.accept(dependency)) continue;
                        result.add(dependency);
                    }
                    dependenciesConsumer.consume((Object)result);
                });
            });
        }, ModalityState.any());
    }

    private static /* synthetic */ boolean lambda$findDependentFiles$0(@NotNull GlobalSearchScope scope, Set result, Pair pair) {
        VirtualFile file;
        if (scope == null) {
            FileDependencyFinder.$$$reportNull$$$0(23);
        }
        if (scope.contains(file = (VirtualFile)pair.getFirst())) {
            result.add(file);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 9: 
            case 14: 
            case 18: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/config/FileDependencyFinder";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/config/FileDependencyFinder";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependentFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDependentFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDependenciesAsync";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findDependenciesAsync$3";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findDependentFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

