/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;

public class OverwriteRemoteWarningDialog
extends DialogWrapper {
    private String myFilePath;
    private Action myOverwriteAction;
    private Action myMergeAction;
    private Action mySkipAction;
    private String myServerName;
    private static final int OVERWRITE_EXIT_CODE = 3;
    private static final int MERGE_EXIT_CODE = 4;
    private static final int SKIP_EXIT_CODE = 5;
    private boolean myProvideDoNotAsk;
    private boolean myRemember;

    public static OverwriteRemoteWarningDialog createInstance(ConnectionOwner connectionOwner, FileObject file, Deployable server, boolean provideDoNotAsk) {
        Component component = connectionOwner.getComponentForDialogCreation();
        OverwriteRemoteWarningDialog dialog = component != null ? new OverwriteRemoteWarningDialog(component) : new OverwriteRemoteWarningDialog(connectionOwner.getProjectForDialogCreation());
        dialog.init(file, server, provideDoNotAsk);
        return dialog;
    }

    private OverwriteRemoteWarningDialog(Project project) {
        super(project, true);
    }

    private OverwriteRemoteWarningDialog(@NotNull Component parentComponent) {
        if (parentComponent == null) {
            OverwriteRemoteWarningDialog.$$$reportNull$$$0(0);
        }
        super(parentComponent, true);
    }

    private void init(FileObject file, Deployable server, boolean provideDoNotAsk) {
        this.myProvideDoNotAsk = provideDoNotAsk;
        this.setTitle(WDBundle.message("overwrite.remote.dialog.title", server.getName()));
        this.myServerName = server.getName();
        this.myFilePath = server.getPresentablePath(file);
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file.getName().getBaseName());
        this.myMergeAction = fileType.isBinary() || fileType.isReadOnly() ? null : new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, WDBundle.message("overwrite.remote.dialog.merge.action.name", new Object[0]), 4);
        this.myOverwriteAction = new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, WDBundle.message("overwrite.remote.dialog.overwrite.action.name", new Object[0]), 3);
        this.mySkipAction = new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, WDBundle.message("overwrite.remote.dialog.skip.action.name", new Object[0]), 5);
        this.init();
    }

    public void setSkipActionTitle(String title) {
        this.mySkipAction.putValue("Name", title);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(WDBundle.message(this.myMergeAction != null ? "overwrite.remote.dialog.text" : "overwrite.remote.dialog.text.binary", this.myFilePath, this.myServerName));
        label.setIconTextGap(10);
        label.setIcon(Messages.getWarningIcon());
        panel.add((Component)label, "Center");
        if (this.myProvideDoNotAsk) {
            JPanel southPanel = new JPanel(new BorderLayout());
            final JCheckBox checkBox = new JCheckBox();
            checkBox.setText(WDBundle.message("remember.for.this.upload.do.not.ask.again", new Object[0]));
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    OverwriteRemoteWarningDialog.this.myRemember = checkBox.isSelected();
                }
            });
            southPanel.add((Component)checkBox, "Center");
            southPanel.add(Box.createVerticalStrut(10), "North");
            panel.add((Component)southPanel, "South");
        } else {
            panel.add(Box.createVerticalStrut(10), "South");
        }
        return panel;
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myMergeAction != null) {
            Action[] actionArray = new Action[]{this.myOverwriteAction, this.myMergeAction, this.mySkipAction};
            if (actionArray == null) {
                OverwriteRemoteWarningDialog.$$$reportNull$$$0(1);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.myOverwriteAction, this.mySkipAction};
        if (actionArray == null) {
            OverwriteRemoteWarningDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    @NotNull
    public OverwriteOption getResult() {
        int code = this.getExitCode();
        switch (code) {
            case 3: {
                OverwriteOption overwriteOption = OverwriteOption.OVERWRITE;
                if (overwriteOption == null) {
                    OverwriteRemoteWarningDialog.$$$reportNull$$$0(3);
                }
                return overwriteOption;
            }
            case 4: {
                OverwriteOption overwriteOption = OverwriteOption.MERGE;
                if (overwriteOption == null) {
                    OverwriteRemoteWarningDialog.$$$reportNull$$$0(4);
                }
                return overwriteOption;
            }
            case 5: {
                OverwriteOption overwriteOption = OverwriteOption.SKIP;
                if (overwriteOption == null) {
                    OverwriteRemoteWarningDialog.$$$reportNull$$$0(5);
                }
                return overwriteOption;
            }
            case 1: {
                OverwriteOption overwriteOption = OverwriteOption.SKIP;
                if (overwriteOption == null) {
                    OverwriteRemoteWarningDialog.$$$reportNull$$$0(6);
                }
                return overwriteOption;
            }
        }
        throw new IllegalStateException("Unexpected code " + code);
    }

    public boolean isRememberForUpload() {
        return this.myRemember && this.getExitCode() != 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OverwriteOption {
        SKIP,
        MERGE,
        OVERWRITE;

    }
}

