/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.BitUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightManagerImpl
extends HighlightManager {
    private final Project myProject;
    private final Key<Map<RangeHighlighter, HighlightInfo>> HIGHLIGHT_INFO_MAP_KEY = Key.create((String)"HIGHLIGHT_INFO_MAP_KEY");

    public HighlightManagerImpl(Project project, ActionManagerEx actionManagerEx, EditorFactory editorFactory) {
        this.myProject = project;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject).subscribe(AnActionListener.TOPIC, (Object)new MyAnActionListener());
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Editor[] editors;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Document document = event.getDocument();
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
                    Map map = HighlightManagerImpl.this.getHighlightInfoMap(editor, false);
                    if (map == null) {
                        return;
                    }
                    ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
                    for (RangeHighlighter highlighter : map.keySet()) {
                        HighlightInfo info = (HighlightInfo)map.get(highlighter);
                        if (!info.editor.getDocument().equals(document) || !BitUtil.isSet((int)info.flags, (int)4)) continue;
                        highlightersToRemove.add(highlighter);
                    }
                    for (RangeHighlighter highlighter : highlightersToRemove) {
                        HighlightManagerImpl.this.removeSegmentHighlighter(editor, highlighter);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/highlighting/HighlightManagerImpl$1", "documentChanged"));
            }
        };
        editorFactory.getEventMulticaster().addDocumentListener(documentListener, (Disposable)this.myProject);
    }

    @Nullable
    private Map<RangeHighlighter, HighlightInfo> getHighlightInfoMap(@NotNull Editor editor, boolean toCreate) {
        Map map;
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(0);
        }
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        if ((map = (Map)editor.getUserData(this.HIGHLIGHT_INFO_MAP_KEY)) == null && toCreate) {
            map = (Map)((UserDataHolderEx)editor).putUserDataIfAbsent(this.HIGHLIGHT_INFO_MAP_KEY, new HashMap());
        }
        return map;
    }

    @NotNull
    public RangeHighlighter[] getHighlighters(@NotNull Editor editor) {
        Map<RangeHighlighter, HighlightInfo> highlightersMap;
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(1);
        }
        if ((highlightersMap = this.getHighlightInfoMap(editor, false)) == null) {
            if (RangeHighlighter.EMPTY_ARRAY == null) {
                HighlightManagerImpl.$$$reportNull$$$0(2);
            }
            return RangeHighlighter.EMPTY_ARRAY;
        }
        HashSet<RangeHighlighter> set = new HashSet<RangeHighlighter>();
        for (Map.Entry<RangeHighlighter, HighlightInfo> entry : highlightersMap.entrySet()) {
            HighlightInfo info = entry.getValue();
            if (!info.editor.equals(editor)) continue;
            set.add(entry.getKey());
        }
        RangeHighlighter[] rangeHighlighterArray = set.toArray(RangeHighlighter.EMPTY_ARRAY);
        if (rangeHighlighterArray == null) {
            HighlightManagerImpl.$$$reportNull$$$0(3);
        }
        return rangeHighlighterArray;
    }

    private RangeHighlighter addSegmentHighlighter(@NotNull Editor editor, int startOffset, int endOffset, TextAttributes attributes, @HighlightManager.HideFlags int flags) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(4);
        }
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        HighlightInfo info = new HighlightInfo(editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor, flags);
        Map<RangeHighlighter, HighlightInfo> map = this.getHighlightInfoMap(editor, true);
        map.put(highlighter, info);
        return highlighter;
    }

    public boolean removeSegmentHighlighter(@NotNull Editor editor, @NotNull RangeHighlighter highlighter) {
        Map<RangeHighlighter, HighlightInfo> map;
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(5);
        }
        if (highlighter == null) {
            HighlightManagerImpl.$$$reportNull$$$0(6);
        }
        if ((map = this.getHighlightInfoMap(editor, false)) == null) {
            return false;
        }
        HighlightInfo info = map.get(highlighter);
        if (info == null) {
            return false;
        }
        MarkupModel markupModel = info.editor.getMarkupModel();
        if (((MarkupModelEx)markupModel).containsHighlighter(highlighter)) {
            highlighter.dispose();
        }
        map.remove(highlighter);
        return true;
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiReference[] occurrences, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(7);
        }
        if (occurrences == null) {
            HighlightManagerImpl.$$$reportNull$$$0(8);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(9);
        }
        if (occurrences.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        int oldOffset = editor.getCaretModel().getOffset();
        int horizontalScrollOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        int verticalScrollOffset = editor.getScrollingModel().getVerticalScrollOffset();
        for (PsiReference occurrence : occurrences) {
            Project project;
            PsiElement element = occurrence.getElement();
            int startOffset = element.getTextRange().getStartOffset();
            int start2 = startOffset + occurrence.getRangeInElement().getStartOffset();
            int end = startOffset + occurrence.getRangeInElement().getEndOffset();
            PsiFile containingFile = element.getContainingFile();
            Editor textEditor = InjectedLanguageUtil.openEditorFor(containingFile, project = element.getProject());
            if (textEditor == null) continue;
            this.addOccurrenceHighlight(textEditor, start2, end, attributes, flags, outHighlighters, scrollMarkColor);
        }
        editor.getCaretModel().moveToOffset(oldOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getScrollingModel().scrollHorizontally(horizontalScrollOffset);
        editor.getScrollingModel().scrollVertically(verticalScrollOffset);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor, int start2, int end, TextAttributes attributes, int flags, Collection<RangeHighlighter> outHighlighters, Color scrollMarkColor) {
        RangeHighlighter highlighter;
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(10);
        }
        if ((highlighter = this.addSegmentHighlighter(editor, start2, end, attributes, flags)) instanceof RangeHighlighterEx) {
            ((RangeHighlighterEx)highlighter).setVisibleIfFolded(true);
        }
        if (outHighlighters != null) {
            outHighlighters.add(highlighter);
        }
        if (scrollMarkColor != null) {
            highlighter.setErrorStripeMarkColor(scrollMarkColor);
        }
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, @Nullable Collection<RangeHighlighter> highlighters) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(11);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(12);
        }
        this.addRangeHighlight(editor, startOffset, endOffset, attributes, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<RangeHighlighter> highlighters) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(13);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(14);
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        if (hideByAnyKey) {
            flags |= 2;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        this.addOccurrenceHighlight(editor, startOffset, endOffset, attributes, flags, highlighters, scrollMarkColor);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(15);
        }
        if (elements == null) {
            HighlightManagerImpl.$$$reportNull$$$0(16);
        }
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(17);
        }
        if (elements.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        for (PsiElement element : elements) {
            TextRange range2 = element.getTextRange();
            range2 = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element, range2);
            this.addOccurrenceHighlight(editor, HighlightManagerImpl.trimOffsetToDocumentSize(editor, range2.getStartOffset()), HighlightManagerImpl.trimOffsetToDocumentSize(editor, range2.getEndOffset()), attributes, flags, outHighlighters, scrollMarkColor);
        }
    }

    private static int trimOffsetToDocumentSize(@NotNull Editor editor, int offset) {
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(18);
        }
        if (offset < 0) {
            return 0;
        }
        int textLength = editor.getDocument().getTextLength();
        return offset < textLength ? offset : textLength;
    }

    @Nullable
    private static Color getScrollMarkColor(@NotNull TextAttributes attributes, @NotNull EditorColorsScheme colorScheme) {
        if (attributes == null) {
            HighlightManagerImpl.$$$reportNull$$$0(19);
        }
        if (colorScheme == null) {
            HighlightManagerImpl.$$$reportNull$$$0(20);
        }
        if (attributes.getErrorStripeColor() != null) {
            return attributes.getErrorStripeColor();
        }
        if (attributes.getBackgroundColor() != null) {
            boolean isDark = ColorUtil.isDark((Color)colorScheme.getDefaultBackground());
            return isDark ? attributes.getBackgroundColor().brighter() : attributes.getBackgroundColor().darker();
        }
        return null;
    }

    public boolean hideHighlights(@NotNull Editor editor, @HighlightManager.HideFlags int mask) {
        Map<RangeHighlighter, HighlightInfo> map;
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(21);
        }
        if ((map = this.getHighlightInfoMap(editor, false)) == null) {
            return false;
        }
        boolean done = false;
        ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
        for (RangeHighlighter highlighter : map.keySet()) {
            HighlightInfo info = map.get(highlighter);
            if (!info.editor.equals(editor) || (info.flags & mask) == 0) continue;
            highlightersToRemove.add(highlighter);
            done = true;
        }
        for (RangeHighlighter highlighter : highlightersToRemove) {
            this.removeSegmentHighlighter(editor, highlighter);
        }
        return done;
    }

    boolean hasHideByEscapeHighlighters(@NotNull Editor editor) {
        Map<RangeHighlighter, HighlightInfo> map;
        if (editor == null) {
            HighlightManagerImpl.$$$reportNull$$$0(22);
        }
        if ((map = this.getHighlightInfoMap(editor, false)) != null) {
            for (HighlightInfo info : map.values()) {
                if (!info.editor.equals(editor) || (info.flags & 1) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorScheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoMap";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighters";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSegmentHighlighter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeSegmentHighlighter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addOccurrenceHighlights";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addOccurrenceHighlight";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlight";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "trimOffsetToDocumentSize";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getScrollMarkColor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hideHighlights";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasHideByEscapeHighlighters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HighlightInfo {
        final Editor editor;
        @HighlightManager.HideFlags
        final int flags;

        HighlightInfo(Editor editor, @HighlightManager.HideFlags int flags) {
            this.editor = editor;
            this.flags = flags;
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, AnActionEvent event) {
            if (action == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            this.requestHideHighlights(dataContext);
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            this.requestHideHighlights(dataContext);
        }

        private void requestHideHighlights(@NotNull DataContext dataContext) {
            Editor editor;
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(3);
            }
            if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) == null) {
                return;
            }
            HighlightManagerImpl.this.hideHighlights(editor, 2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/highlighting/HighlightManagerImpl$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestHideHighlights";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

