/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.util.SVGLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class UIThemeBasedLookAndFeelInfo
extends UIManager.LookAndFeelInfo {
    private final UITheme myTheme;
    private boolean myInitialised;

    public UIThemeBasedLookAndFeelInfo(UITheme theme) {
        super(theme.getName(), theme.isDark() ? DarculaLaf.class.getName() : IntelliJLaf.class.getName());
        this.myTheme = theme;
    }

    public UITheme getTheme() {
        return this.myTheme;
    }

    public void installTheme(UIDefaults defaults) {
        SVGLoader.SvgColorPatcher colorPatcher;
        this.myTheme.applyProperties(defaults);
        IconPathPatcher patcher = this.myTheme.getPatcher();
        if (patcher != null) {
            IconLoader.installPathPatcher((IconPathPatcher)patcher);
        }
        if ((colorPatcher = this.myTheme.getColorPatcher()) != null) {
            SVGLoader.setColorPatcher((SVGLoader.SvgColorPatcher)colorPatcher);
        }
        this.installBackgroundImage();
        this.installEditorScheme();
        this.myInitialised = true;
    }

    public boolean isInitialised() {
        return this.myInitialised;
    }

    private void installEditorScheme() {
        EditorColorsScheme scheme2;
        String name = this.myTheme.getEditorSchemeName();
        if (name != null && (scheme2 = EditorColorsManager.getInstance().getScheme(name)) != null) {
            EditorColorsManager.getInstance().setGlobalScheme(scheme2);
        }
    }

    private void installBackgroundImage() {
        block27: {
            try {
                Object path;
                Map<String, Object> background = this.myTheme.getBackground();
                if (background == null || !((path = background.get("image")) instanceof String)) break block27;
                File tmpImage = FileUtil.createTempFile((String)"ijBackgroundImage", (String)path.toString().substring(((String)path).lastIndexOf(".")), (boolean)true);
                URL resource = this.myTheme.getProviderClassLoader().getResource((String)path);
                if (resource != null) {
                    try (InputStream input = this.myTheme.getProviderClassLoader().getResourceAsStream((String)path);
                         FileOutputStream output = new FileOutputStream(tmpImage);){
                        FileUtil.copy((InputStream)input, (OutputStream)output);
                    }
                    String image = tmpImage.getPath();
                    Object transparency = background.get("transparency");
                    String alpha = String.valueOf(transparency instanceof Integer ? (Integer)transparency : 15);
                    String fill = UIThemeBasedLookAndFeelInfo.parseEnumValue(background.get("fill"), IdeBackgroundUtil.Fill.SCALE);
                    String anchor2 = UIThemeBasedLookAndFeelInfo.parseEnumValue(background.get("anchor"), IdeBackgroundUtil.Anchor.CENTER);
                    String spec = StringUtil.join((String[])new String[]{image, alpha, fill, anchor2}, (String)",");
                    String currentSpec = PropertiesComponent.getInstance().getValue("idea.background.editor");
                    PropertiesComponent.getInstance().setValue("old.idea.background.editor", currentSpec);
                    PropertiesComponent.getInstance().setValue("idea.background.editor", spec);
                    IdeBackgroundUtil.repaintAllWindows();
                    break block27;
                }
                throw new IllegalArgumentException("Can't load background: " + path);
            }
            catch (IOException boom) {
                Logger.getInstance(this.getClass()).error((Throwable)boom);
            }
        }
    }

    private static <T extends Enum<T>> String parseEnumValue(Object value, T defaultValue) {
        if (value instanceof String) {
            String name = StringUtil.toUpperCase((String)((String)value));
            for (Enum t : (Enum[])defaultValue.getClass().getEnumConstants()) {
                if (!t.name().equals(name)) continue;
                return StringUtil.toLowerCase((String)value.toString());
            }
        }
        return StringUtil.toLowerCase((String)defaultValue.name());
    }

    public void dispose() {
        IconPathPatcher patcher = this.myTheme.getPatcher();
        if (patcher != null) {
            IconLoader.removePathPatcher((IconPathPatcher)patcher);
        }
        SVGLoader.setColorPatcher(null);
        String value = PropertiesComponent.getInstance().getValue("old.idea.background.editor");
        PropertiesComponent.getInstance().unsetValue("old.idea.background.editor");
        if (value == null) {
            PropertiesComponent.getInstance().unsetValue("idea.background.editor");
        } else {
            PropertiesComponent.getInstance().setValue("idea.background.editor", value);
        }
    }
}

