/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItem;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.ListChooseByNameModel;
import com.intellij.internal.statistic.service.fus.beans.FSContent;
import com.intellij.internal.statistic.service.fus.beans.FSGroup;
import com.intellij.internal.statistic.service.fus.beans.FSSession;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsAggregator;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectFUStatisticsAction
extends GotoActionBase {
    @Override
    protected void gotoActionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            CollectFUStatisticsAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Object[] projectCollectors = Extensions.getExtensions((String)ProjectUsagesCollector.getExtensionPointName());
        Object[] applicationCollectors = Extensions.getExtensions((String)ApplicationUsagesCollector.getExtensionPointName());
        ArrayList<Item> items = new ArrayList<Item>();
        for (Object collector : ContainerUtil.concat((Object[][])new Object[][]{projectCollectors, applicationCollectors})) {
            if (!(collector instanceof FeatureUsagesCollector)) continue;
            String groupId = ((FeatureUsagesCollector)collector).getGroupId();
            String className = StringUtil.nullize((String)collector.getClass().getSimpleName(), (boolean)true);
            items.add(new Item(groupId, className));
        }
        ContainerUtil.sort(items, Comparator.comparing(it -> ((Item)it).myGroupId));
        MyChooseByNameModel model = new MyChooseByNameModel(project, items);
        ChooseByNamePopup popup2 = ChooseByNamePopup.createPopup(project, (ChooseByNameModel)model, GotoActionBase.getPsiContext(e));
        popup2.setShowListForEmptyPattern(true);
        popup2.invoke(new ChooseByNamePopupComponent.Callback(){

            public void onClose() {
                if (((Object)((Object)CollectFUStatisticsAction.this)).getClass().equals(myInAction)) {
                    myInAction = null;
                }
            }

            public void elementChosen(Object element) {
                CollectFUStatisticsAction.showCollectorUsages(project, ((Item)element).myGroupId);
            }
        }, ModalityState.current(), false);
    }

    private static void showCollectorUsages(@NotNull Project project, @NotNull String groupId) {
        FUStatisticsAggregator aggregator;
        FSContent data;
        if (project == null) {
            CollectFUStatisticsAction.$$$reportNull$$$0(1);
        }
        if (groupId == null) {
            CollectFUStatisticsAction.$$$reportNull$$$0(2);
        }
        if ((data = (aggregator = FUStatisticsAggregator.create(false)).getUsageCollectorsData(Collections.singleton(groupId))) == null) {
            Messages.showErrorDialog((Project)project, (String)"Can't collect usages", (String)"Error");
            return;
        }
        StringBuilder result2 = new StringBuilder();
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        for (FSSession session2 : ContainerUtil.notNullize(data.getSessions())) {
            for (FSGroup group : ContainerUtil.filter((Collection)ContainerUtil.notNullize(session2.getGroups()), it -> {
                if (groupId == null) {
                    CollectFUStatisticsAction.$$$reportNull$$$0(3);
                }
                return groupId.equals(it.id);
            })) {
                result2.append(gson2.toJson((Object)group, FSGroup.class));
                result2.append("\n\n");
            }
        }
        JTextArea textArea = new JTextArea(result2.toString());
        DialogBuilder builder2 = new DialogBuilder();
        builder2.setCenterPanel((JComponent)ScrollPaneFactory.createScrollPane((Component)textArea));
        builder2.setPreferredFocusComponent((JComponent)textArea);
        builder2.setTitle(groupId);
        builder2.addOkAction();
        builder2.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/actions/CollectFUStatisticsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "gotoActionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showCollectorUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$showCollectorUsages$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyChooseByNameModel
    extends ListChooseByNameModel<Item> {
        private MyChooseByNameModel(Project project, List<Item> items) {
            super(project, "Enter usage collector group id", "No collectors found", items);
        }

        @Override
        public boolean useMiddleMatching() {
            return true;
        }
    }

    private static class Item
    implements ChooseByNameItem {
        @NotNull
        private final String myGroupId;
        @Nullable
        private final String myClassName;

        private Item(@NotNull String groupId, @Nullable String className) {
            if (groupId == null) {
                Item.$$$reportNull$$$0(0);
            }
            this.myGroupId = groupId;
            this.myClassName = className;
        }

        @Override
        public String getName() {
            return this.myGroupId;
        }

        @Override
        public String getDescription() {
            return this.myClassName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/internal/statistic/actions/CollectFUStatisticsAction$Item", "<init>"));
        }
    }
}

