/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntProcedure;
import java.awt.AWTEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class ModifierKeyDoubleClickHandler
implements Disposable,
BaseComponent {
    private static final Logger LOG = Logger.getInstance(ModifierKeyDoubleClickHandler.class);
    private static final TIntIntHashMap KEY_CODE_TO_MODIFIER_MAP = new TIntIntHashMap();
    private final ActionManagerEx myActionManagerEx;
    private final ConcurrentMap<String, MyDispatcher> myDispatchers = ContainerUtil.newConcurrentMap();
    private boolean myIsRunningAction;

    private ModifierKeyDoubleClickHandler(ActionManagerEx actionManagerEx) {
        this.myActionManagerEx = actionManagerEx;
    }

    public void initComponent() {
        int modifierKeyCode = ModifierKeyDoubleClickHandler.getMultiCaretActionModifier();
        this.registerAction("EditorCloneCaretAbove", modifierKeyCode, 38);
        this.registerAction("EditorCloneCaretBelow", modifierKeyCode, 40);
        this.registerAction("EditorLeftWithSelection", modifierKeyCode, 37);
        this.registerAction("EditorRightWithSelection", modifierKeyCode, 39);
        this.registerAction("EditorLineStartWithSelection", modifierKeyCode, 36);
        this.registerAction("EditorLineEndWithSelection", modifierKeyCode, 35);
    }

    public void dispose() {
        for (MyDispatcher dispatcher : this.myDispatchers.values()) {
            Disposer.dispose((Disposable)dispatcher);
        }
        this.myDispatchers.clear();
    }

    public static ModifierKeyDoubleClickHandler getInstance() {
        return (ModifierKeyDoubleClickHandler)ApplicationManager.getApplication().getComponent(ModifierKeyDoubleClickHandler.class);
    }

    public static int getMultiCaretActionModifier() {
        return SystemInfo.isMac ? 18 : 17;
    }

    public void registerAction(@NotNull String actionId, int modifierKeyCode, int actionKeyCode, boolean skipIfActionHasShortcut) {
        if (actionId == null) {
            ModifierKeyDoubleClickHandler.$$$reportNull$$$0(0);
        }
        MyDispatcher dispatcher = new MyDispatcher(actionId, modifierKeyCode, actionKeyCode, skipIfActionHasShortcut);
        MyDispatcher oldDispatcher = this.myDispatchers.put(actionId, dispatcher);
        IdeEventQueue.getInstance().addDispatcher(dispatcher, dispatcher);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)dispatcher).subscribe(AnActionListener.TOPIC, (Object)dispatcher);
        if (oldDispatcher != null) {
            Disposer.dispose((Disposable)oldDispatcher);
        }
    }

    public void registerAction(@NotNull String actionId, int modifierKeyCode, int actionKeyCode) {
        if (actionId == null) {
            ModifierKeyDoubleClickHandler.$$$reportNull$$$0(1);
        }
        this.registerAction(actionId, modifierKeyCode, actionKeyCode, true);
    }

    public void unregisterAction(@NotNull String actionId) {
        MyDispatcher oldDispatcher;
        if (actionId == null) {
            ModifierKeyDoubleClickHandler.$$$reportNull$$$0(2);
        }
        if ((oldDispatcher = (MyDispatcher)this.myDispatchers.remove(actionId)) != null) {
            Disposer.dispose((Disposable)oldDispatcher);
        }
    }

    public boolean isRunningAction() {
        return this.myIsRunningAction;
    }

    static {
        KEY_CODE_TO_MODIFIER_MAP.put(18, 8);
        KEY_CODE_TO_MODIFIER_MAP.put(17, 2);
        KEY_CODE_TO_MODIFIER_MAP.put(157, 4);
        KEY_CODE_TO_MODIFIER_MAP.put(16, 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "actionId";
        objectArray2[1] = "com/intellij/openapi/keymap/impl/ModifierKeyDoubleClickHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDispatcher
    implements IdeEventQueue.EventDispatcher,
    Disposable,
    AnActionListener {
        private final String myActionId;
        private final int myModifierKeyCode;
        private final int myActionKeyCode;
        private final boolean mySkipIfActionHasShortcut;
        private final Couple<AtomicBoolean> ourPressed;
        private final Couple<AtomicBoolean> ourReleased;
        private final AtomicBoolean ourOtherKeyWasPressed;
        private final AtomicLong ourLastTimePressed;

        MyDispatcher(String actionId, int modifierKeyCode, int actionKeyCode, boolean skipIfActionHasShortcut) {
            if (actionId == null) {
                MyDispatcher.$$$reportNull$$$0(0);
            }
            this.ourPressed = Couple.of((Object)new AtomicBoolean(false), (Object)new AtomicBoolean(false));
            this.ourReleased = Couple.of((Object)new AtomicBoolean(false), (Object)new AtomicBoolean(false));
            this.ourOtherKeyWasPressed = new AtomicBoolean(false);
            this.ourLastTimePressed = new AtomicLong(0L);
            this.myActionId = actionId;
            this.myModifierKeyCode = modifierKeyCode;
            this.myActionKeyCode = actionKeyCode;
            this.mySkipIfActionHasShortcut = skipIfActionHasShortcut;
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent event) {
            if (event == null) {
                MyDispatcher.$$$reportNull$$$0(1);
            }
            if (event instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)event;
                int keyCode = keyEvent.getKeyCode();
                LOG.debug("", new Object[]{this, event});
                if (keyCode == this.myModifierKeyCode) {
                    if (this.hasOtherModifiers(keyEvent)) {
                        this.resetState();
                        return false;
                    }
                    if (this.myActionKeyCode == -1 && this.ourOtherKeyWasPressed.get() && keyEvent.getWhen() - this.ourLastTimePressed.get() < 100L) {
                        this.resetState();
                        return false;
                    }
                    this.ourOtherKeyWasPressed.set(false);
                    if (((AtomicBoolean)this.ourPressed.first).get() && keyEvent.getWhen() - this.ourLastTimePressed.get() > 500L) {
                        this.resetState();
                    }
                    this.handleModifier((KeyEvent)event);
                    return false;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get() && ((AtomicBoolean)this.ourPressed.second).get() && this.myActionKeyCode != -1) {
                    if (keyCode == this.myActionKeyCode && !this.hasOtherModifiers(keyEvent)) {
                        if (event.getID() == 401) {
                            return this.run(keyEvent);
                        }
                        return true;
                    }
                    return false;
                }
                this.ourLastTimePressed.set(keyEvent.getWhen());
                this.ourOtherKeyWasPressed.set(true);
                if (keyCode == 27 || keyCode == 9) {
                    this.ourLastTimePressed.set(0L);
                }
                this.resetState();
            }
            return false;
        }

        private boolean hasOtherModifiers(KeyEvent keyEvent) {
            final int modifiers = keyEvent.getModifiers();
            return !KEY_CODE_TO_MODIFIER_MAP.forEachEntry(new TIntIntProcedure(){

                public boolean execute(int keyCode, int modifierMask) {
                    return keyCode == MyDispatcher.this.myModifierKeyCode || (modifiers & modifierMask) == 0;
                }
            });
        }

        private void handleModifier(KeyEvent event) {
            if (((AtomicBoolean)this.ourPressed.first).get() && event.getWhen() - this.ourLastTimePressed.get() > 300L) {
                this.resetState();
                return;
            }
            if (event.getID() == 401) {
                if (!((AtomicBoolean)this.ourPressed.first).get()) {
                    this.resetState();
                    ((AtomicBoolean)this.ourPressed.first).set(true);
                    this.ourLastTimePressed.set(event.getWhen());
                    return;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get()) {
                    ((AtomicBoolean)this.ourPressed.second).set(true);
                    this.ourLastTimePressed.set(event.getWhen());
                    return;
                }
            } else if (event.getID() == 402) {
                if (((AtomicBoolean)this.ourPressed.first).get() && !((AtomicBoolean)this.ourReleased.first).get()) {
                    ((AtomicBoolean)this.ourReleased.first).set(true);
                    this.ourLastTimePressed.set(event.getWhen());
                    return;
                }
                if (((AtomicBoolean)this.ourPressed.first).get() && ((AtomicBoolean)this.ourReleased.first).get() && ((AtomicBoolean)this.ourPressed.second).get()) {
                    this.resetState();
                    if (this.myActionKeyCode == -1 && !this.shouldSkipIfActionHasShortcut()) {
                        this.run(event);
                    }
                    return;
                }
            }
            this.resetState();
        }

        private void resetState() {
            ((AtomicBoolean)this.ourPressed.first).set(false);
            ((AtomicBoolean)this.ourPressed.second).set(false);
            ((AtomicBoolean)this.ourReleased.first).set(false);
            ((AtomicBoolean)this.ourReleased.second).set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean run(KeyEvent event) {
            ModifierKeyDoubleClickHandler.this.myIsRunningAction = true;
            try {
                AnAction action = ModifierKeyDoubleClickHandler.this.myActionManagerEx.getAction(this.myActionId);
                if (action == null) {
                    boolean bl = false;
                    return bl;
                }
                DataContext context = DataManager.getInstance().getDataContext(IdeFocusManager.findInstance().getFocusOwner());
                AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)event, (String)"MainMenu", (DataContext)context);
                action.update(anActionEvent);
                if (!anActionEvent.getPresentation().isEnabled()) {
                    boolean bl = false;
                    return bl;
                }
                ModifierKeyDoubleClickHandler.this.myActionManagerEx.fireBeforeActionPerformed(action, anActionEvent.getDataContext(), anActionEvent);
                action.actionPerformed(anActionEvent);
                ModifierKeyDoubleClickHandler.this.myActionManagerEx.fireAfterActionPerformed(action, anActionEvent.getDataContext(), anActionEvent);
                ActionsCollector.getInstance().record("DoubleShortcut", action.getClass(), anActionEvent);
                boolean bl = true;
                return bl;
            }
            finally {
                ModifierKeyDoubleClickHandler.this.myIsRunningAction = false;
            }
        }

        private boolean shouldSkipIfActionHasShortcut() {
            return this.mySkipIfActionHasShortcut && KeymapUtil.getActiveKeymapShortcuts((String)this.myActionId).getShortcuts().length > 0;
        }

        public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, AnActionEvent event) {
            if (action == null) {
                MyDispatcher.$$$reportNull$$$0(2);
            }
            if (dataContext == null) {
                MyDispatcher.$$$reportNull$$$0(3);
            }
            if (!ModifierKeyDoubleClickHandler.this.myIsRunningAction) {
                this.resetState();
            }
        }

        public void dispose() {
        }

        public String toString() {
            return "modifier double-click dispatcher [modifierKeyCode=" + this.myModifierKeyCode + ",actionKeyCode=" + this.myActionKeyCode + ",actionId=" + this.myActionId + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ModifierKeyDoubleClickHandler$MyDispatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dispatch";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

