/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.layout.migLayout;

import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.SpacingConfiguration;
import com.intellij.ui.layout.migLayout.ComponentConstraintsKt;
import com.intellij.ui.layout.migLayout.DefaultComponentConstraintCreator$WhenMappings;
import com.intellij.ui.layout.migLayout.MigLayoutBuilderKt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.DimConstraint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002JZ\u0010\u0018\u001a\u0004\u0018\u00010\u00122\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001a2\b\b\u0002\u0010\u001d\u001a\u00020\u001a2\b\b\u0002\u0010\u001e\u001a\u00020\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ui/layout/migLayout/DefaultComponentConstraintCreator;", "", "spacing", "Lcom/intellij/ui/layout/SpacingConfiguration;", "(Lcom/intellij/ui/layout/SpacingConfiguration;)V", "horizontalUnitSizeGap", "Lnet/miginfocom/layout/BoundSize;", "getHorizontalUnitSizeGap", "()Lnet/miginfocom/layout/BoundSize;", "mediumTextSizeSpec", "kotlin.jvm.PlatformType", "shortTextSizeSpec", "vertical1pxGap", "getVertical1pxGap", "addGrowIfNeed", "", "cc", "Lkotlin/Lazy;", "Lnet/miginfocom/layout/CC;", "component", "Ljava/awt/Component;", "applyGrowPolicy", "growPolicy", "Lcom/intellij/ui/layout/GrowPolicy;", "createComponentConstraints", "gapLeft", "", "gapAfter", "gapTop", "gapBottom", "split", "intellij.platform.ide.impl"})
public final class DefaultComponentConstraintCreator {
    private final BoundSize shortTextSizeSpec;
    private final BoundSize mediumTextSizeSpec;
    @NotNull
    private final BoundSize vertical1pxGap;
    @NotNull
    private final BoundSize horizontalUnitSizeGap;
    private final SpacingConfiguration spacing;

    @NotNull
    public final BoundSize getVertical1pxGap() {
        return this.vertical1pxGap;
    }

    @NotNull
    public final BoundSize getHorizontalUnitSizeGap() {
        return this.horizontalUnitSizeGap;
    }

    @Nullable
    public final CC createComponentConstraints(@NotNull Lazy<CC> cc, @NotNull Component component, int gapLeft, int gapAfter, int gapTop, int gapBottom, int split, @Nullable GrowPolicy growPolicy) {
        Intrinsics.checkParameterIsNotNull(cc, (String)"cc");
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        if (gapLeft != 0) {
            DimConstraint dimConstraint = ((CC)cc.getValue()).getHorizontal();
            Intrinsics.checkExpressionValueIsNotNull((Object)dimConstraint, (String)"cc.value.horizontal");
            dimConstraint.setGapBefore(MigLayoutBuilderKt.gapToBoundSize(gapLeft, true));
        }
        if (gapAfter != 0) {
            DimConstraint dimConstraint = ((CC)cc.getValue()).getHorizontal();
            Intrinsics.checkExpressionValueIsNotNull((Object)dimConstraint, (String)"cc.value.horizontal");
            dimConstraint.setGapAfter(MigLayoutBuilderKt.gapToBoundSize(gapAfter, true));
        }
        if (gapTop != 0) {
            DimConstraint dimConstraint = ((CC)cc.getValue()).getVertical();
            Intrinsics.checkExpressionValueIsNotNull((Object)dimConstraint, (String)"cc.value.vertical");
            dimConstraint.setGapBefore(MigLayoutBuilderKt.gapToBoundSize(gapTop, false));
        }
        if (gapBottom != 0) {
            DimConstraint dimConstraint = ((CC)cc.getValue()).getVertical();
            Intrinsics.checkExpressionValueIsNotNull((Object)dimConstraint, (String)"cc.value.vertical");
            dimConstraint.setGapAfter(MigLayoutBuilderKt.gapToBoundSize(gapBottom, false));
        }
        if (split != -1) {
            ((CC)cc.getValue()).setSplit(split);
        }
        if (growPolicy != null) {
            this.applyGrowPolicy((CC)cc.getValue(), growPolicy);
        } else {
            this.addGrowIfNeed(cc, component, this.spacing);
        }
        return cc.isInitialized() ? (CC)cc.getValue() : null;
    }

    @Nullable
    public static /* synthetic */ CC createComponentConstraints$default(DefaultComponentConstraintCreator defaultComponentConstraintCreator, Lazy lazy, Component component, int n, int n2, int n3, int n4, int n5, GrowPolicy growPolicy, int n6, Object object) {
        if ((n6 & 4) != 0) {
            n = 0;
        }
        if ((n6 & 8) != 0) {
            n2 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x20) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x40) != 0) {
            n5 = -1;
        }
        return defaultComponentConstraintCreator.createComponentConstraints((Lazy<CC>)lazy, component, n, n2, n3, n4, n5, growPolicy);
    }

    private final void addGrowIfNeed(Lazy<CC> cc, Component component, SpacingConfiguration spacing) {
        if (component instanceof ComponentWithBrowseButton) {
            ((CC)cc.getValue()).minWidth(spacing.getMaxShortTextWidth() + "px");
            ((CC)cc.getValue()).growX();
        } else if (component instanceof JPasswordField) {
            this.applyGrowPolicy((CC)cc.getValue(), GrowPolicy.SHORT_TEXT);
        } else if (component instanceof JTextComponent || component instanceof SeparatorComponent || component instanceof ComponentWithBrowseButton) {
            ((CC)cc.getValue()).growX();
        } else if (component instanceof JScrollPane || ComponentConstraintsKt.access$isPanelWithToolbar(component)) {
            ((CC)cc.getValue()).grow().pushY();
        }
        if (component instanceof JScrollPane) {
            JViewport jViewport = ((JScrollPane)component).getViewport();
            Intrinsics.checkExpressionValueIsNotNull((Object)jViewport, (String)"component.viewport");
            Component view = jViewport.getView();
            if (view instanceof JTextArea && ((JTextArea)view).getRows() == 0) {
                ((JTextArea)view).setRows(3);
            }
        }
    }

    private final void applyGrowPolicy(CC cc, GrowPolicy growPolicy) {
        BoundSize boundSize;
        DimConstraint dimConstraint = cc.getHorizontal();
        Intrinsics.checkExpressionValueIsNotNull((Object)dimConstraint, (String)"cc.horizontal");
        switch (DefaultComponentConstraintCreator$WhenMappings.$EnumSwitchMapping$0[growPolicy.ordinal()]) {
            case 1: {
                boundSize = this.shortTextSizeSpec;
                break;
            }
            case 2: {
                boundSize = this.mediumTextSizeSpec;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        dimConstraint.setSize(boundSize);
    }

    public DefaultComponentConstraintCreator(@NotNull SpacingConfiguration spacing) {
        Intrinsics.checkParameterIsNotNull((Object)spacing, (String)"spacing");
        this.spacing = spacing;
        this.shortTextSizeSpec = ConstraintParser.parseBoundSize((String)(this.spacing.getShortTextWidth() + "px!"), (boolean)false, (boolean)true);
        this.mediumTextSizeSpec = ConstraintParser.parseBoundSize((String)(this.spacing.getShortTextWidth() + "px::" + this.spacing.getMaxShortTextWidth() + "px"), (boolean)false, (boolean)true);
        BoundSize boundSize = ConstraintParser.parseBoundSize((String)(JBUI.scale((int)1) + "px!"), (boolean)true, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)boundSize, (String)"ConstraintParser.parseBo\u2026ale(1)}px!\", true, false)");
        this.vertical1pxGap = boundSize;
        this.horizontalUnitSizeGap = MigLayoutBuilderKt.gapToBoundSize(this.spacing.getUnitSize(), true);
    }
}

