/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import java.io.IOException;
import purejavacomm.testsuite.TestBase;

public class Test9
extends TestBase {
    static volatile boolean m_ReadThreadRunning;
    static volatile int m_ReadBytes;
    static volatile long m_T0;
    static volatile long m_T1;
    static byte[] m_TxBuffer;
    static byte[] m_RxBuffer;

    static void startReadThread() throws Exception {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                m_ReadThreadRunning = true;
                try {
                    m_T0 = System.currentTimeMillis();
                    m_ReadBytes = TestBase.m_In.read(m_RxBuffer, 0, m_RxBuffer.length);
                    m_T1 = System.currentTimeMillis();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                m_ReadThreadRunning = false;
            }
        });
        m_ReadThreadRunning = false;
        thread.setPriority(10);
        thread.start();
        while (!m_ReadThreadRunning) {
            Thread.sleep(10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void run() throws Exception {
        try {
            int n;
            int n2;
            Test9.begin("Test9 - treshold 100, timeout 100 ");
            Test9.openPort();
            m_Out = m_Port.getOutputStream();
            m_In = m_Port.getInputStream();
            m_Port.enableReceiveTimeout(100);
            m_Port.enableReceiveThreshold(100);
            Test9.startReadThread();
            Test9.sleep(500);
            if (m_ReadThreadRunning) {
                Test9.fail("read did not timeout", new Object[0]);
            }
            Test9.startReadThread();
            int n3 = 10;
            int n4 = 50;
            for (n2 = 0; n2 < 1000; ++n2) {
                m_Out.write(m_TxBuffer, 0, n3);
                Test9.sleep(50);
                if (!m_ReadThreadRunning) break;
            }
            if (m_ReadThreadRunning) {
                Test9.fail("read did not complete in resonable time", new Object[0]);
            }
            if (m_ReadBytes < 100) {
                Test9.fail("expected at minimum 100 bytes but got " + m_ReadBytes, new Object[0]);
            }
            if (m_ReadThreadRunning) {
                Test9.fail("read did not complete in time", new Object[0]);
            }
            if ((n2 = (int)(m_T1 - m_T0)) > (n = (100 / n3 + 2) * n4)) {
                Test9.fail("was expecting read to happen in " + n + " but it took " + n2 + " msec", new Object[0]);
            }
            Test9.finishedOK();
        }
        finally {
            Test9.closePort();
        }
    }

    static {
        m_ReadBytes = 0;
        m_TxBuffer = new byte[1000];
        m_RxBuffer = new byte[m_TxBuffer.length];
    }
}

