/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.bundles.BundleFactory;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.editor.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.TextMateFileType;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateCustomTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTheme;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.XmlPlistReader;

public class TextMateServiceImpl
extends TextMateService {
    private final Map<String, TextMateCustomTextAttributes> myCustomHighlightingColors = ContainerUtil.newHashMap();
    private final XmlPlistReader myPlistReader = new XmlPlistReader();
    private final BundleFactory myBundleFactory = new BundleFactory(this.myPlistReader);
    private final TextMateSyntaxTable mySyntaxTable = new TextMateSyntaxTable();
    private final Map<String, TextMateTheme> myThemeHashMap = ContainerUtil.newHashMap();
    private final SnippetsRegistry mySnippetsRegistry = new SnippetsRegistry();
    private final PreferencesRegistry myPreferencesRegistry = new PreferencesRegistry();
    private final ShellVariablesRegistry myShellVariablesRegistry = new ShellVariablesRegistry();
    private final Map<String, String> myExtensionsMapping = ContainerUtil.newHashMap();
    @NonNls
    private static final String PREINSTALLED_THEMES_PATH = FileUtil.join((String[])new String[]{PathManager.getPreInstalledPluginsPath(), "textmate", "lib", "themes"});
    @NonNls
    private static final String INSTALLED_THEMES_PATH = FileUtil.join((String[])new String[]{PathManager.getPluginsPath(), "textmate", "lib", "themes"});
    private final Set<TextMateService.TextMateBundleListener> myListeners = ContainerUtil.newHashSet();

    @Override
    public void registerEnabledBundles(boolean fireFileEvents) {
        TextMateSettings settings = TextMateSettings.getInstance();
        if (settings != null) {
            Collection<BundleConfigBean> bundles = settings.getBundles();
            for (BundleConfigBean bundleConfigBean : bundles) {
                boolean result;
                if (!bundleConfigBean.isEnabled() || (result = this.registerBundle(LocalFileSystem.getInstance().findFileByPath(bundleConfigBean.getPath()), fireFileEvents))) continue;
                Notifications.Bus.notify((Notification)new Notification("TextMate Bundles", "TextMate bundle load error", "Bundle " + bundleConfigBean.getName() + " can't be registered", NotificationType.ERROR, null));
            }
            this.cleanUpRedundantAssociations();
        }
    }

    @Override
    public void unregisterAllBundles(boolean unregisterFileTypes) {
        if (unregisterFileTypes) {
            FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                for (FileNameMatcher matcher : fileTypeManager.getAssociations((FileType)TextMateFileType.INSTANCE)) {
                    fileTypeManager.removeAssociation((FileType)TextMateFileType.INSTANCE, matcher, false);
                }
            }));
        }
        this.myExtensionsMapping.clear();
        this.myPreferencesRegistry.clear();
        this.myCustomHighlightingColors.clear();
        this.mySyntaxTable.clear();
        this.mySnippetsRegistry.clear();
        this.myShellVariablesRegistry.clear();
    }

    @Override
    public void addListener(@NotNull TextMateService.TextMateBundleListener listener) {
        if (listener == null) {
            TextMateServiceImpl.$$$reportNull$$$0(0);
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull TextMateService.TextMateBundleListener listener) {
        if (listener == null) {
            TextMateServiceImpl.$$$reportNull$$$0(1);
        }
        this.myListeners.remove(listener);
    }

    @Override
    public void clearListeners() {
        this.myListeners.clear();
    }

    @Override
    @NotNull
    public XmlPlistReader getPlistReader() {
        XmlPlistReader xmlPlistReader = this.myPlistReader;
        if (xmlPlistReader == null) {
            TextMateServiceImpl.$$$reportNull$$$0(2);
        }
        return xmlPlistReader;
    }

    @Override
    @NotNull
    public Map<String, TextMateCustomTextAttributes> getCustomHighlightingColors() {
        Map<String, TextMateCustomTextAttributes> map = this.myCustomHighlightingColors;
        if (map == null) {
            TextMateServiceImpl.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Override
    @NotNull
    public List<Preferences> getPreferencesForSelector(@NotNull String selector) {
        if (selector == null) {
            TextMateServiceImpl.$$$reportNull$$$0(4);
        }
        List<Preferences> list = this.myPreferencesRegistry.getPreferences(selector);
        if (list == null) {
            TextMateServiceImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @Nullable
    public String getVariableValue(@NotNull String name, @NotNull EditorEx editor) {
        if (name == null) {
            TextMateServiceImpl.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            TextMateServiceImpl.$$$reportNull$$$0(7);
        }
        return this.myShellVariablesRegistry.getVariableValue(name, TextMateEditorUtils.getCurrentScopeSelector(editor));
    }

    @Override
    @NotNull
    public SnippetsRegistry getSnippetsRegistry() {
        SnippetsRegistry snippetsRegistry = this.mySnippetsRegistry;
        if (snippetsRegistry == null) {
            TextMateServiceImpl.$$$reportNull$$$0(8);
        }
        return snippetsRegistry;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull String fileName) {
        if (fileName == null) {
            TextMateServiceImpl.$$$reportNull$$$0(9);
        }
        for (String extension : TextMateServiceImpl.getExtensions(fileName)) {
            TextMateLanguageDescriptor languageDescriptor = this.getLanguageDescriptorByExtension(extension);
            if (languageDescriptor == null) continue;
            return languageDescriptor;
        }
        return null;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByExtension(String extension) {
        String scopeName = this.myExtensionsMapping.get(extension);
        return StringUtil.isNotEmpty((String)scopeName) ? new TextMateLanguageDescriptor(scopeName, this.mySyntaxTable.getSyntax(scopeName)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerTheme(@Nullable VirtualFile themeFile) {
        if (themeFile == null || !themeFile.isValid()) {
            return false;
        }
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        synchronized (map) {
            try {
                TextMateTheme theme = TextMateTheme.load(this.myPlistReader.read(themeFile.getInputStream()));
                if (theme != TextMateTheme.EMPTY_THEME) {
                    this.myThemeHashMap.put(theme.getName(), theme);
                    for (TextMateService.TextMateBundleListener listener : this.myListeners) {
                        listener.colorSchemeChanged();
                    }
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String[] getThemeNames() {
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        // MONITORENTER : map
        String[] stringArray = ArrayUtil.toStringArray(this.myThemeHashMap.keySet());
        // MONITOREXIT : map
        if (stringArray != null) return stringArray;
        TextMateServiceImpl.$$$reportNull$$$0(10);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public TextMateTheme getCurrentTheme() {
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        // MONITORENTER : map
        String currentIdeaSchemeName = SchemeManager.getDisplayName((Scheme)EditorColorsManager.getInstance().getGlobalScheme());
        String textmateSchemeName = TextMateSettings.getInstance().getTextMateThemeName(currentIdeaSchemeName, this);
        String schemeName = this.myThemeHashMap.containsKey(textmateSchemeName) ? textmateSchemeName : "Mac Classic";
        TextMateTheme scheme = this.myThemeHashMap.get(schemeName);
        TextMateTheme textMateTheme = scheme != null ? scheme : TextMateTheme.EMPTY_THEME;
        // MONITOREXIT : map
        if (textMateTheme != null) return textMateTheme;
        TextMateServiceImpl.$$$reportNull$$$0(11);
        return textMateTheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadThemesFromDisk() {
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        synchronized (map) {
            this.myThemeHashMap.clear();
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            VirtualFile themesDirectory = LocalFileSystem.getInstance().findFileByPath(INSTALLED_THEMES_PATH);
            if (themesDirectory == null) {
                themesDirectory = LocalFileSystem.getInstance().findFileByPath(PREINSTALLED_THEMES_PATH);
            }
            if (themesDirectory != null) {
                VirtualFile finalThemesDirectory = themesDirectory;
                Runnable reloadThemes = () -> {
                    Map<String, TextMateTheme> map = this.myThemeHashMap;
                    synchronized (map) {
                        if (finalThemesDirectory.isValid()) {
                            for (VirtualFile themeFile : finalThemesDirectory.getChildren()) {
                                this.registerTheme(themeFile);
                            }
                        }
                    }
                };
                if (ModalityState.current() == ModalityState.NON_MODAL) {
                    themesDirectory.refresh(true, false, reloadThemes);
                } else {
                    reloadThemes.run();
                }
            }
        });
    }

    @Override
    @Nullable
    public Bundle createBundle(@Nullable VirtualFile directory) {
        String path;
        if (directory != null && directory.isInLocalFileSystem() && (path = directory.getCanonicalPath()) != null) {
            return this.myBundleFactory.fromDirectory(new File(path));
        }
        return null;
    }

    private boolean registerBundle(VirtualFile directory, boolean fireFileEvents) {
        Bundle bundle = this.createBundle(directory);
        if (bundle != null) {
            this.registerLanguageSupport(bundle, fireFileEvents);
            this.registerPreferences(bundle);
            this.registerSnippets(bundle);
            this.registerThemes(bundle);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerThemes(@NotNull Bundle bundle) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(12);
        }
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        synchronized (map) {
            for (File themeFile : bundle.getThemeFiles()) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)themeFile, (boolean)true);
                this.registerTheme(virtualFile);
            }
        }
    }

    private void registerSnippets(@NotNull Bundle bundle) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(13);
        }
        for (File snippetFile : bundle.getSnippetFiles()) {
            try {
                TextMateSnippet snippet = PreferencesReadUtil.loadSnippet(snippetFile, this.myPlistReader.read(snippetFile));
                if (snippet == null) continue;
                this.mySnippetsRegistry.register(snippet);
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + snippetFile.getPath());
            }
        }
    }

    private void registerPreferences(@NotNull Bundle bundle) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(14);
        }
        for (File preferenceFile : bundle.getPreferenceFiles()) {
            try {
                Plist plist = this.myPlistReader.read(preferenceFile);
                Pair<String, Plist> settingsPair = PreferencesReadUtil.retrieveSettingsPlist(plist);
                if (settingsPair == null) continue;
                this.myPreferencesRegistry.fillFromPList((String)settingsPair.first, (Plist)settingsPair.second);
                this.myShellVariablesRegistry.fillVariablesFromPlist((String)settingsPair.first, (Plist)settingsPair.second);
                this.readCustomHighlightingColors((String)settingsPair.first, (Plist)settingsPair.second);
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + preferenceFile.getPath());
            }
        }
    }

    private void readCustomHighlightingColors(@NotNull String scopeName, @NotNull Plist preferencesPList) {
        TextAttributes textAttributes;
        boolean hasHighlightingSettings;
        if (scopeName == null) {
            TextMateServiceImpl.$$$reportNull$$$0(15);
        }
        if (preferencesPList == null) {
            TextMateServiceImpl.$$$reportNull$$$0(16);
        }
        if (hasHighlightingSettings = PreferencesReadUtil.fillTextAttributes(textAttributes = new TextAttributes(), preferencesPList, null)) {
            double backgroundAlpha = PreferencesReadUtil.getBackgroundAlpha(preferencesPList);
            this.myCustomHighlightingColors.put(scopeName, new TextMateCustomTextAttributes(textAttributes, backgroundAlpha));
        }
    }

    private void registerLanguageSupport(@NotNull Bundle bundle, boolean fireFileEvents) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(17);
        }
        for (File grammarFile : bundle.getGrammarFiles()) {
            try {
                Plist plist = this.myPlistReader.read(grammarFile);
                String rootScopeName = this.mySyntaxTable.loadSyntax(plist);
                List<String> extensions = plist.getPlistValue("fileTypes", Collections.emptyList()).getStringArray();
                for (String extension : extensions) {
                    this.myExtensionsMapping.put(extension, rootScopeName);
                }
            }
            catch (IOException e) {
                LOG.warn("Can't load textmate language file: " + grammarFile.getPath());
            }
        }
        TextMateServiceImpl.registerTextMateExtensions(this.myExtensionsMapping.keySet(), fireFileEvents);
    }

    private void cleanUpRedundantAssociations() {
        HashSet associationsToDelete = ContainerUtil.newHashSet();
        FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
        for (FileNameMatcher nameMatcher : fileTypeManager.getAssociations((FileType)TextMateFileType.INSTANCE)) {
            String typeKey;
            if (nameMatcher instanceof ExtensionFileNameMatcher) {
                typeKey = ((ExtensionFileNameMatcher)nameMatcher).getExtension();
            } else {
                if (!(nameMatcher instanceof ExactFileNameMatcher)) continue;
                typeKey = ((ExactFileNameMatcher)nameMatcher).getFileName();
            }
            if (this.myExtensionsMapping.containsKey(typeKey)) continue;
            associationsToDelete.add(nameMatcher);
        }
        TransactionGuard.getInstance().submitTransactionLater((Disposable)ApplicationManager.getApplication(), () -> WriteAction.run(() -> {
            for (FileNameMatcher nameMatcher : associationsToDelete) {
                fileTypeManager.removeAssociation((FileType)TextMateFileType.INSTANCE, nameMatcher, false);
            }
            if (!associationsToDelete.isEmpty()) {
                fileTypeManager.fireBeforeFileTypesChanged();
                fileTypeManager.fireFileTypesChanged();
            }
        }));
    }

    private static void registerTextMateExtensions(@NotNull Collection<String> extensions, boolean fireFileEvents) {
        if (extensions == null) {
            TextMateServiceImpl.$$$reportNull$$$0(18);
        }
        TransactionGuard.getInstance().submitTransactionLater((Disposable)ApplicationManager.getApplication(), () -> {
            if (extensions == null) {
                TextMateServiceImpl.$$$reportNull$$$0(20);
            }
            WriteAction.run(() -> {
                if (extensions == null) {
                    TextMateServiceImpl.$$$reportNull$$$0(21);
                }
                boolean fileTypeUpdated = false;
                FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
                for (String extension : extensions) {
                    FileType registeredType = fileTypeManager.getFileTypeByFileName(extension);
                    if (TextMateServiceImpl.isTypeShouldBeReplacedByTextMateType(registeredType)) {
                        fileTypeManager.associate((FileType)TextMateFileType.INSTANCE, FileTypeManager.parseFromString((String)extension), false);
                        fileTypeUpdated = true;
                    }
                    if (!TextMateServiceImpl.isTypeShouldBeReplacedByTextMateType(registeredType = fileTypeManager.getFileTypeByExtension(extension))) continue;
                    fileTypeManager.associate((FileType)TextMateFileType.INSTANCE, (FileNameMatcher)new ExtensionFileNameMatcher(extension), false);
                    fileTypeUpdated = true;
                }
                if (fireFileEvents && fileTypeUpdated) {
                    fileTypeManager.fireBeforeFileTypesChanged();
                    fileTypeManager.fireFileTypesChanged();
                }
            });
        });
    }

    public static boolean isTypeShouldBeReplacedByTextMateType(FileType registeredType) {
        return registeredType == UnknownFileType.INSTANCE || registeredType == TextMateFileType.INSTANCE || registeredType == PlainTextFileType.INSTANCE;
    }

    public static Collection<String> getExtensions(@NotNull String name) {
        String extension;
        if (name == null) {
            TextMateServiceImpl.$$$reportNull$$$0(19);
        }
        ArrayList result = ContainerUtil.newArrayList((Object[])new String[]{name});
        int index = name.indexOf(46);
        while (index >= 0 && !(extension = name.substring(index + 1)).isEmpty()) {
            result.add(extension);
            index = name.indexOf(46, index + 1);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/TextMateServiceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferencesPList";
                break;
            }
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/TextMateServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlistReader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomHighlightingColors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferencesForSelector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnippetsRegistry";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemeNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPreferencesForSelector";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVariableValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDescriptorByFileName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerThemes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerSnippets";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerPreferences";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readCustomHighlightingColors";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerLanguageSupport";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerTextMateExtensions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerTextMateExtensions$7";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

