/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text.minimatch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.minimatch.GlobStar;
import com.intellij.util.text.minimatch.Minimatch;
import com.intellij.util.text.minimatch.MinimatchOptions;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005\u001a\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\"\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017\u001a\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"GLOBSTAR", "Lcom/intellij/util/text/minimatch/GlobStar;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "QMARK", "", "STAR", "hasBraces", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "reSpecials", "slashSplit", "unescape", "globUnescape", "s", "minimatch", "", "p", "pattern", "options", "Lcom/intellij/util/text/minimatch/MinimatchOptions;", "minimatchAll", "path", "", "", "patterns", "Lcom/intellij/util/text/minimatch/Minimatch;", "replaceEscapedBackSlash", "intellij.nodeJS"})
public final class MinimatchKt {
    private static final Logger LOG;
    private static final GlobStar GLOBSTAR;
    private static final Pattern hasBraces;
    private static final Pattern slashSplit;
    private static final String QMARK = "[^/]";
    private static final String STAR = "[^/]*?";
    private static final String reSpecials = "().*{}+?[]^$\\!";
    private static final Pattern unescape;

    @JvmOverloads
    public static final boolean minimatch(@NotNull String p, @NotNull String pattern, @NotNull MinimatchOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        if (StringsKt.isBlank((CharSequence)pattern)) {
            CharSequence charSequence = p;
            return charSequence.length() == 0;
        }
        if (!options.getNocomment() && StringsKt.startsWith$default((CharSequence)pattern, (char)'#', (boolean)false, (int)2, null)) {
            return false;
        }
        return Minimatch.match$default(new Minimatch(pattern, options), p, false, 2, null);
    }

    @JvmOverloads
    public static /* synthetic */ boolean minimatch$default(String string, String string2, MinimatchOptions minimatchOptions, int n, Object object) {
        if ((n & 4) != 0) {
            minimatchOptions = new MinimatchOptions(false, false, false, false, false, false, false, false, false, false, 1023, null);
        }
        return MinimatchKt.minimatch(string, string2, minimatchOptions);
    }

    @JvmOverloads
    public static final boolean minimatch(@NotNull String p, @NotNull String pattern) {
        return MinimatchKt.minimatch$default(p, pattern, null, 4, null);
    }

    @NotNull
    public static final String replaceEscapedBackSlash(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        return StringsKt.replace$default((String)s, (String)"\\\\", (String)"/", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String globUnescape(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        String string = unescape.matcher(s).replaceAll("$1");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unescape.matcher(s).replaceAll(\"$1\")");
        return string;
    }

    public static final boolean minimatchAll(@NotNull List<? extends CharSequence> path, @NotNull List<Minimatch> patterns) {
        Intrinsics.checkParameterIsNotNull(path, (String)"path");
        Intrinsics.checkParameterIsNotNull(patterns, (String)"patterns");
        boolean match = false;
        for (Minimatch pattern : patterns) {
            if (match != pattern.getNegate()) continue;
            match = Minimatch.match$default(pattern, path, false, 2, null);
        }
        return match;
    }

    static {
        Logger logger = Logger.getInstance(Minimatch.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        GLOBSTAR = new GlobStar();
        hasBraces = Pattern.compile("\\{.*\\}");
        slashSplit = Pattern.compile("/+");
        QMARK = QMARK;
        STAR = QMARK + "*?";
        unescape = Pattern.compile("\\\\(.)");
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Pattern access$getSlashSplit$p() {
        return slashSplit;
    }

    @NotNull
    public static final /* synthetic */ GlobStar access$getGLOBSTAR$p() {
        return GLOBSTAR;
    }

    @NotNull
    public static final /* synthetic */ String access$getSTAR$p() {
        return STAR;
    }

    @NotNull
    public static final /* synthetic */ String access$getQMARK$p() {
        return QMARK;
    }

    public static final /* synthetic */ Pattern access$getHasBraces$p() {
        return hasBraces;
    }
}

