/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.jetbrains.nodejs.run.profile.V8Utils;
import gnu.trove.TIntArrayList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Flags
implements Externalizable {
    private static final int canBeQueried = 1;
    private static final int detachedDOMTreeNode = 2;
    private static final int pageObject = 4;
    private static final int visitedMarkerMask = 65535;
    private static final int visitedMarker = 65536;
    private TIntArrayList myFlags;

    public Flags(int nodesCnt) {
        this.myFlags = new TIntArrayList(nodesCnt);
        for (int i = 0; i < nodesCnt; ++i) {
            this.myFlags.add(0);
        }
    }

    public Flags() {
    }

    boolean visitedAndPage(int idx) {
        return (this.myFlags.get(idx) & 0x10004) > 0;
    }

    void clearVisited(int idx) {
        int val = this.myFlags.get(idx);
        this.myFlags.set(idx, val & 0xFFFF);
    }

    public boolean isPage(int idx) {
        return (this.myFlags.get(idx) & 4) > 0;
    }

    void addPage(int idx) {
        int val = this.myFlags.get(idx);
        this.myFlags.set(idx, val | 4);
    }

    void addVisited(int idx) {
        int val = this.myFlags.get(idx);
        this.myFlags.set(idx, val | 0x10000);
    }

    public boolean isQueriable(int idx) {
        return (this.myFlags.get(idx) & 1) > 0;
    }

    void addQueriableFlag(int idx) {
        int val = this.myFlags.get(idx);
        this.myFlags.set(idx, val | 1);
    }

    void addDetachedFlag(int idx) {
        int val = this.myFlags.get(idx);
        this.myFlags.set(idx, val | 2);
    }

    public boolean isDetached(int idx) {
        return (this.myFlags.get(idx) & 2) > 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        V8Utils.writeIntList(this.myFlags, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.myFlags = V8Utils.readIntList(in);
    }
}

