/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient;

import java.io.IOException;
import java.util.Date;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IConnectionStreams;
import org.netbeans.lib.cvsclient.response.IResponseHandler;
import org.netbeans.lib.cvsclient.response.IResponseServices;

public class ErrorDefendingResponseHandler
implements IResponseHandler {
    private static final int MAX_ERRORS_NUM = 50;
    private final long myErrorStreamTimeout;
    private static final long ourOkConstant = -1L;
    private long myErrorStreamStart;
    private int myConsequentErrorsCount;
    private final IResponseHandler myHandler;

    public ErrorDefendingResponseHandler(long errorStreamTimeout, IResponseHandler handler) {
        this.myErrorStreamTimeout = errorStreamTimeout;
        this.myHandler = handler;
        this.myErrorStreamStart = -1L;
        this.myConsequentErrorsCount = 0;
    }

    private void onError() {
        ++this.myConsequentErrorsCount;
        if (-1L == this.myErrorStreamStart) {
            this.myErrorStreamStart = System.currentTimeMillis();
        }
    }

    private void onOk() {
        this.myErrorStreamStart = -1L;
        this.myConsequentErrorsCount = 0;
    }

    public boolean interrupt() {
        return this.myConsequentErrorsCount >= 50 || this.myErrorStreamTimeout > 0L && -1L != this.myErrorStreamStart && System.currentTimeMillis() - this.myErrorStreamStart >= this.myErrorStreamTimeout;
    }

    @Override
    public void processErrorMessageResponse(byte[] message, IResponseServices responseServices) {
        this.myHandler.processErrorMessageResponse(message, responseServices);
        this.onError();
    }

    @Override
    public void processMessageResponse(byte[] message, IResponseServices responseServices) {
        this.myHandler.processMessageResponse(message, responseServices);
        this.onOk();
    }

    @Override
    public void processMessageTaggedResponse(byte[] message, IResponseServices responseServices) {
        this.myHandler.processMessageTaggedResponse(message, responseServices);
        this.onOk();
    }

    @Override
    public void processCheckedInResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        this.myHandler.processCheckedInResponse(relativeLocalDirectory, repositoryFilePath, entryLine, responseServices, clientEnvironment);
        this.onOk();
    }

    @Override
    public void processNewEntryResponse(String relativeLocalDirectory, String repositoryFilePath, IResponseServices responseServoces, String entryLine, IClientEnvironment clientEnvironment) throws IOException {
        this.myHandler.processNewEntryResponse(relativeLocalDirectory, repositoryFilePath, responseServoces, entryLine, clientEnvironment);
        this.onOk();
    }

    @Override
    public void processSetStaticDirectoryResponse(String relativeLocalDirectory, String repositoryFilePath, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        this.myHandler.processSetStaticDirectoryResponse(relativeLocalDirectory, repositoryFilePath, responseServices, clientEnvironment);
        this.onOk();
    }

    @Override
    public void processClearStaticDirectoryResponse(String relativeLocalDirectory, String repositoryDirectoryPath, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        this.myHandler.processClearStaticDirectoryResponse(relativeLocalDirectory, repositoryDirectoryPath, responseServices, clientEnvironment);
        this.onOk();
    }

    @Override
    public void processSetStickyResponse(String relativeLocalDirectory, String repositoryFilePath, String tag, IClientEnvironment clientEnvironment) throws IOException {
        this.myHandler.processSetStickyResponse(relativeLocalDirectory, repositoryFilePath, tag, clientEnvironment);
        this.onOk();
    }

    @Override
    public void processClearStickyResponse(String relativeLocalDirectory, String repositoryFilePath, IClientEnvironment clientEnvironment) throws IOException {
        this.myHandler.processClearStickyResponse(relativeLocalDirectory, repositoryFilePath, clientEnvironment);
        this.onOk();
    }

    @Override
    public void processNotifiedResponse(String relativeLocalDirectory, String repositoryFilePath, IClientEnvironment clientEnvironment) {
        this.myHandler.processNotifiedResponse(relativeLocalDirectory, repositoryFilePath, clientEnvironment);
        this.onOk();
    }

    @Override
    public void processRemovedResponse(String relativeLocalDirectory, String repositoryFilePath, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        this.myHandler.processRemovedResponse(relativeLocalDirectory, repositoryFilePath, responseServices, clientEnvironment);
        this.onOk();
    }

    @Override
    public void processRemoveEntryResponse(String relativeLocalDirectory, String repositoryFilePath, IResponseServices responseServices, IClientEnvironment clientEnvironment) throws IOException {
        this.myHandler.processRemoveEntryResponse(relativeLocalDirectory, repositoryFilePath, responseServices, clientEnvironment);
        this.onOk();
    }

    @Override
    public void processCopyFileResponse(String relativeLocalDirectory, String repositoryFilePath, String newName, IClientEnvironment clientEnvironment) throws IOException {
        this.myHandler.processCopyFileResponse(relativeLocalDirectory, repositoryFilePath, newName, clientEnvironment);
        this.onOk();
    }

    @Override
    public void processModTimeResponse(Date modifiedDate, IResponseServices responseServices) {
        this.myHandler.processModTimeResponse(modifiedDate, responseServices);
        this.onOk();
    }

    @Override
    public void processModeResponse(String mode, IResponseServices responseServices) {
        this.myHandler.processModeResponse(mode, responseServices);
        this.onOk();
    }

    @Override
    public void processTemplateResponse(String relativeLocalDirectory, String repositoryFilePath, int length, IClientEnvironment clientEnvironment, IConnectionStreams connectionStreams) throws IOException {
        this.myHandler.processTemplateResponse(relativeLocalDirectory, repositoryFilePath, length, clientEnvironment, connectionStreams);
        this.onOk();
    }

    @Override
    public void processModuleExpansionResponse(String localPath, IResponseServices responseServices) {
        this.myHandler.processModuleExpansionResponse(localPath, responseServices);
        this.onOk();
    }

    @Override
    public void processOkResponse(IResponseServices responseServices) {
        this.myHandler.processOkResponse(responseServices);
        this.onOk();
    }

    @Override
    public void processErrorResponse(byte[] message, IResponseServices responseServices) {
        this.myHandler.processErrorResponse(message, responseServices);
        this.onError();
    }

    @Override
    public void processUpdatedResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine, String mode, int fileLength, IClientEnvironment clientEnvironment, IResponseServices responseServices, IConnectionStreams connectionStreams) throws IOException {
        this.myHandler.processUpdatedResponse(relativeLocalDirectory, repositoryFilePath, entryLine, mode, fileLength, clientEnvironment, responseServices, connectionStreams);
        this.onOk();
    }

    @Override
    public void processMergedResponse(String relativeLocalDirectory, String repositoryFilePath, String entryLine, String mode, int fileLength, IClientEnvironment clientEnvironment, IResponseServices responseServices, IConnectionStreams connectionStreams) throws IOException {
        this.myHandler.processMergedResponse(relativeLocalDirectory, repositoryFilePath, entryLine, mode, fileLength, clientEnvironment, responseServices, connectionStreams);
        this.onOk();
    }

    @Override
    public void processValidRequestsResponse(String validRequests, IResponseServices responseServices) {
        this.myHandler.processValidRequestsResponse(validRequests, responseServices);
        this.onOk();
    }

    @Override
    public void processBinaryMessageResponse(int fileLength, byte[] binaryContent, IResponseServices responseServices) {
        this.myHandler.processBinaryMessageResponse(fileLength, binaryContent, responseServices);
        this.onOk();
    }
}

