/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.lang.PhpLanguage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class BladeIncludeIfInjectionInfo
extends BladeInjectionInfo {
    private static final String MY_MIDDLE_PART = "))\n  echo $__env->make(";

    public BladeIncludeIfInjectionInfo() {
        super("<?php if ($__env->exists(", ", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>", BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
    }

    @Override
    public int getBladePrefixLength() {
        return "(".length();
    }

    @Override
    public int getBladeSuffixLength() {
        return ")".length();
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @Nullable
    public String getUnmodifiablePresentableDescription() {
        return "(\"" + this.getPhpPrefix() + "\", \"" + MY_MIDDLE_PART + "\", \"" + this.getPhpSuffix() + "\")";
    }

    @Override
    @Nullable
    public TextRange convertInjectedRangeToInnerVisible(BladePsiLanguageInjectionHost host, TextRange injected, int length, boolean showEmptyBorderIntersections) {
        int injectedTextLength = host.getTextLength() - this.getBladePrefixLength() - this.getBladeSuffixLength();
        if (injected.getEndOffset() < this.getPhpPrefix().length() || injected.getStartOffset() > this.getPhpPrefix().length() + injectedTextLength) {
            return null;
        }
        if (!(showEmptyBorderIntersections || injected.getEndOffset() != this.getPhpPrefix().length() && injected.getStartOffset() != this.getPhpPrefix().length() + injectedTextLength)) {
            return null;
        }
        int start = Math.max(injected.getStartOffset() - this.getPhpPrefix().length(), 0);
        int end = Math.min(injected.getEndOffset() - this.getPhpPrefix().length(), injected.getStartOffset() - this.getPhpPrefix().length() + injectedTextLength);
        return TextRange.create((int)(this.getBladePrefixLength() + start), (int)(this.getBladePrefixLength() + end));
    }

    @Override
    public void register(MultiHostRegistrar registrar, BladePsiLanguageInjectionHost host, PsiElement child) {
        int startOffsetInParent = child.getStartOffsetInParent();
        TextRange rangeInsideHost = new TextRange(startOffsetInParent, startOffsetInParent + child.getTextLength());
        String suffix = MY_MIDDLE_PART + rangeInsideHost.substring(host.getText()) + this.getPhpSuffix();
        registrar.startInjecting((Language)PhpLanguage.INSTANCE).addPlace(this.getPhpPrefix(), suffix, (PsiLanguageInjectionHost)host, rangeInsideHost).doneInjecting();
    }

    @Override
    @NonNls
    public String toString() {
        return "BIIInfo{prefix='" + this.getPhpPrefix() + '\'' + ", middlePart='" + MY_MIDDLE_PART + "', suffix='" + this.getPhpSuffix() + "\\}";
    }
}

