/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JSParameterCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters completionParameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (completionParameters == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSParameterCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement parent = completionParameters.getPosition().getParent();
        assert (parent instanceof JSParameter);
        JSFunction function = ((JSParameter)parent).getDeclaringFunction();
        if (function instanceof JSFunctionExpression) {
            PsiElement sourceElement;
            JSType type = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)function));
            if ((type = JSTypeUtils.getValuableType(type)) instanceof JSFunctionTypeImpl && (sourceElement = type.getSource().getSourceElement()) instanceof JSFunctionItem) {
                String name;
                JSParameterItem[] expectedParameters = ((JSFunctionItem)sourceElement).getParameters();
                JSParameterListElement[] functionParameters = function.getParameters();
                int paramIndex = -1;
                for (int i = 0; i < functionParameters.length; ++i) {
                    if (parent != functionParameters[i]) continue;
                    paramIndex = i;
                    break;
                }
                if (paramIndex == 0 && functionParameters.length == 1 && expectedParameters.length > 0) {
                    StringBuilder parameters = new StringBuilder();
                    for (JSParameterItem expectedParameter : expectedParameters) {
                        if (parameters.length() > 0) {
                            parameters.append(", ");
                        }
                        parameters.append(expectedParameter.getName());
                    }
                    result2.addElement(JSLookupUtilImpl.createMultiparamCompletionItem(sourceElement, parameters.toString()));
                }
                if (paramIndex >= 0 && paramIndex < expectedParameters.length && (name = expectedParameters[paramIndex].getName()) != null) {
                    result2.addElement((LookupElement)LookupElementBuilder.create((Object)sourceElement, (String)name).withIcon(PlatformIcons.PARAMETER_ICON));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "completionParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/completion/JSParameterCompletionProvider";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

