/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSWithObjectLiteralSurrounder
implements Surrounder {
    public String getTemplateDescription() {
        return JSBundle.message((String)"javascript.surround.with.object.literal", (Object[])new Object[0]);
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            JSWithObjectLiteralSurrounder.$$$reportNull$$$0(0);
        }
        return Arrays.stream(elements).noneMatch(e -> JSWithObjectLiteralSurrounder.isShorthanded(e) || JSWithObjectLiteralSurrounder.isShorthanded(e.getParent()));
    }

    private static boolean isShorthanded(PsiElement parent) {
        return parent instanceof ES6Property && ((ES6Property)parent).isShorthanded();
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
        PsiElement source;
        if (project == null) {
            JSWithObjectLiteralSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            JSWithObjectLiteralSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            JSWithObjectLiteralSurrounder.$$$reportNull$$$0(3);
        }
        if ((source = elements[0]) instanceof JSExpressionStatement) {
            source = ((JSExpressionStatement)source).getExpression();
        }
        if (source instanceof JSExpression) {
            JSExpression expr = (JSExpression)source;
            ASTNode parenthExprNode = JSChangeUtil.createExpressionWithContext("{ \nproperty: " + expr.getText() + "\n}", (PsiElement)expr);
            expr.getNode().getTreeParent().replaceChild(expr.getNode(), parenthExprNode);
            ASTNode propertyNode = parenthExprNode.findChildByType(JSExtendedLanguagesTokenSetProvider.PROPERTIES);
            assert (propertyNode != null);
            ASTNode propertyIdentifier = propertyNode.findChildByType(JSTokenTypes.IDENTIFIER_TOKENS_SET);
            assert (propertyIdentifier != null);
            return propertyIdentifier.getTextRange();
        }
        assert (source instanceof JSProperty);
        JSProperty property1 = (JSProperty)elements[0];
        JSProperty property2 = (JSProperty)elements[elements.length - 1];
        String propertiesText = property1.getContainingFile().getText().substring(property1.getTextRange().getStartOffset(), property2.getTextRange().getEndOffset());
        if (property1 != property2) {
            PsiElement parent = property1.getParent();
            parent.deleteChildRange(property1.getNextSibling(), (PsiElement)property2);
        }
        ASTNode parenthExprNode = JSChangeUtil.createExpressionWithContext("{ \n" + propertiesText + "\n}", (PsiElement)property1);
        JSExpression value = property1.getValue();
        assert (value != null);
        value.replace(parenthExprNode.getPsi());
        PsiElement propertyIdentifier = property1.getNameIdentifier();
        assert (propertyIdentifier != null);
        return propertyIdentifier.getTextRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/surroundWith/JSWithObjectLiteralSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

