/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;

public class TypeScriptUMDGlobalInspection
extends JSInspection {
    public static final String SHORT_NAME = TypeScriptUMDGlobalInspection.calcShortNameFromClass(TypeScriptUMDGlobalInspection.class);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)node);
                if (node.getQualifier() != null || optionHolder == null || !optionHolder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
                    return;
                }
                TypeScriptUMDGlobalInspection.processUnqualifiedReferenceExpression(holder, node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection$1", "visitJSReferenceExpression"));
            }
        };
        if (jSElementVisitor == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static void processUnqualifiedReferenceExpression(@NotNull ProblemsHolder holder, @NotNull JSReferenceExpression node) {
        PsiElement element;
        ResolveResult[] results;
        if (holder == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(1);
        }
        if (node == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(2);
        }
        if ((results = node.multiResolve(false)).length != 1) {
            return;
        }
        ResolveResult result2 = results[0];
        if (result2.isValidResult() && (element = result2.getElement()) instanceof TypeScriptGlobalModuleExportDeclaration) {
            TypeScriptUMDGlobalInspection.processGlobalModuleExportDeclaration(holder, node, (TypeScriptGlobalModuleExportDeclaration)element);
        }
    }

    private static void processGlobalModuleExportDeclaration(@NotNull ProblemsHolder holder, @NotNull JSReferenceExpression context, @NotNull TypeScriptGlobalModuleExportDeclaration exportDeclaration) {
        boolean isCurrentFileModule;
        if (holder == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(3);
        }
        if (context == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(4);
        }
        if (exportDeclaration == null) {
            TypeScriptUMDGlobalInspection.$$$reportNull$$$0(5);
        }
        boolean bl = isCurrentFileModule = ES6PsiUtil.isExternalModule((PsiElement)context.getContainingFile()) || DialectDetector.isJSX((PsiElement)context);
        if (!holder.isOnTheFly() && !isCurrentFileModule) {
            return;
        }
        ProblemHighlightType type = isCurrentFileModule ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
        ES6ImportAction.DefaultElementFilter filter = new ES6ImportAction.DefaultElementFilter(){

            @Override
            public boolean isValidContext(@NotNull PsiElement context) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection$2", "isValidContext"));
            }
        };
        TypeScriptAddImportStatementFix fix = new TypeScriptAddImportStatementFix(exportDeclaration.getName(), (PsiElement)context, false, filter);
        holder.registerProblem((PsiElement)context, JSBundle.message((String)"typescript.reference.to.umd.global", (Object[])new Object[0]), type, new LocalQuickFix[]{fix});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptUMDGlobalInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedReferenceExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalModuleExportDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

