/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection
extends JSInspection {
    public static final String SHORT_NAME = "TypeScriptAbstractClassConstructorCanBeMadeProtected";

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"typescript.abstract.class.constructor.can.be.made.protected", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(3);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionDeclaration(JSFunction node) {
                PsiElement nameIdentifier;
                if (!node.isConstructor()) {
                    return;
                }
                if (!DialectDetector.isTypeScript((PsiElement)node)) {
                    return;
                }
                JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)node);
                if (containingClass == null) {
                    return;
                }
                JSAttributeList list = node.getAttributeList();
                if (list != null && list.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
                    return;
                }
                if (TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)containingClass) && (nameIdentifier = node.getNameIdentifier()) != null) {
                    for (JSClass subClass : JSInheritanceUtil.findDirectSubClasses(containingClass, true)) {
                        if (subClass.getConstructor() != null) continue;
                        return;
                    }
                    holder.registerProblem(nameIdentifier, TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.this.getDisplayName(), new LocalQuickFix[]{JSFixFactory.getInstance().changeConstructorAccessRightsFix(node, JSAttributeList.AccessType.PROTECTED)});
                }
            }
        };
        if (jSElementVisitor == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(4);
        }
        return jSElementVisitor;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection.$$$reportNull$$$0(5);
        }
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptAbstractClassConstructorCanBeMadeProtectedInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

