/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ForLoopReplaceableByWhileJSInspection
extends JavaScriptInspection {
    public boolean m_ignoreLoopsWithoutConditions = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("for.loop.replaceable.by.while.display.name", new Object[0]);
        if (string == null) {
            ForLoopReplaceableByWhileJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            ForLoopReplaceableByWhileJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("for.loop.replaceable.by.while.problem.descriptor", new Object[0]);
        if (string == null) {
            ForLoopReplaceableByWhileJSInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionJSBundle.message("for.loop.replaceable.by.while.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreLoopsWithoutConditions");
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new ReplaceForByWhileFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopReplaceableByWhileVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/control/ForLoopReplaceableByWhileJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ForLoopReplaceableByWhileVisitor
    extends BaseInspectionVisitor {
        private ForLoopReplaceableByWhileVisitor() {
        }

        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                ForLoopReplaceableByWhileVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSForStatement(statement);
            JSVarStatement varStatement = statement.getVarDeclaration();
            if (varStatement != null) {
                return;
            }
            JSExpression initialization = statement.getInitialization();
            if (initialization != null) {
                return;
            }
            JSExpression update = statement.getUpdate();
            if (update != null) {
                return;
            }
            if (ForLoopReplaceableByWhileJSInspection.this.m_ignoreLoopsWithoutConditions) {
                JSExpression condition = statement.getCondition();
                if (condition == null) {
                    return;
                }
                String conditionText = condition.getText();
                if ("true".equals(conditionText)) {
                    return;
                }
            }
            this.registerStatementError((JSStatement)statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/ForLoopReplaceableByWhileJSInspection$ForLoopReplaceableByWhileVisitor", "visitJSForStatement"));
        }
    }

    private static class ReplaceForByWhileFix
    extends InspectionJSFix {
        private ReplaceForByWhileFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("for.loop.replaceable.by.while.replace.quickfix", new Object[0]);
            if (string == null) {
                ReplaceForByWhileFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement forKeywordElement = descriptor2.getPsiElement();
            JSForStatement forStatement = (JSForStatement)forKeywordElement.getParent();
            assert (forStatement != null);
            JSExpression condition = forStatement.getCondition();
            JSStatement body = forStatement.getBody();
            String bodyText = body == null ? "" : body.getText();
            String whileStatement = condition == null ? "while(true)" + bodyText : "while(" + condition.getText() + ')' + bodyText;
            ReplaceForByWhileFix.replaceStatement((JSStatement)forStatement, whileStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ForLoopReplaceableByWhileJSInspection$ReplaceForByWhileFix", "getFamilyName"));
        }
    }
}

