/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.functionmetrics.NegationCountVisitor;
import org.jetbrains.annotations.NotNull;

public class ThreeNegationsPerFunctionJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("function.with.more.than.three.negations.display.name", new Object[0]);
        if (string == null) {
            ThreeNegationsPerFunctionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.FUNCTIONMETRICS_GROUP_NAME;
        if (string == null) {
            ThreeNegationsPerFunctionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function != null);
        PsiElement lastChild = function.getLastChild();
        NegationCountVisitor visitor = new NegationCountVisitor();
        assert (lastChild != null);
        lastChild.accept((PsiElementVisitor)visitor);
        int negationCount = visitor.getNegationCount();
        if (this.functionHasIdentifier(function)) {
            return InspectionJSBundle.message("function.contains.too.many.negation.error.string", negationCount);
        }
        return InspectionJSBundle.message("anonymous.function.contains.too.many.negation.error.string", negationCount);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/functionmetrics/ThreeNegationsPerFunctionJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            NegationCountVisitor visitor = new NegationCountVisitor();
            PsiElement lastChild = function.getLastChild();
            if (!(lastChild instanceof JSBlockStatement)) {
                return;
            }
            lastChild.accept((PsiElementVisitor)visitor);
            int negationCount = visitor.getNegationCount();
            if (negationCount <= 3) {
                return;
            }
            this.registerFunctionError(function);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/ThreeNegationsPerFunctionJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

