/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView;

import java.util.Collection;
import java.util.Collections;
import org.intellij.plugins.xpathView.util.Copyable;
import org.intellij.plugins.xpathView.util.Namespace;
import org.intellij.plugins.xpathView.util.Variable;
import org.jetbrains.annotations.NotNull;

public final class HistoryElement
implements Copyable<HistoryElement> {
    public static final HistoryElement EMPTY = new HistoryElement();
    public final String expression;
    public final Collection<Variable> variables;
    public final Collection<Namespace> namespaces;

    public HistoryElement(String expression, @NotNull Collection<Variable> variables, @NotNull Collection<Namespace> namespaces) {
        if (variables == null) {
            HistoryElement.$$$reportNull$$$0(0);
        }
        if (namespaces == null) {
            HistoryElement.$$$reportNull$$$0(1);
        }
        this.expression = expression;
        this.variables = Collections.unmodifiableCollection(variables);
        this.namespaces = Collections.unmodifiableCollection(namespaces);
    }

    private HistoryElement() {
        this.expression = null;
        this.variables = Collections.emptySet();
        this.namespaces = Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryElement that = (HistoryElement)o;
        return !(this.expression == null ? that.expression != null : !this.expression.equals(that.expression));
    }

    public int hashCode() {
        return this.expression != null ? this.expression.hashCode() : 0;
    }

    @Override
    public HistoryElement copy() {
        return new HistoryElement(this.expression, Copyable.Util.copy(this.variables), Copyable.Util.copy(this.namespaces));
    }

    public HistoryElement changeContext(Collection<Namespace> namespaces, Collection<Variable> variables) {
        return new HistoryElement(this.expression, variables, namespaces);
    }

    public HistoryElement changeExpression(String expression) {
        return new HistoryElement(expression, this.variables, this.namespaces);
    }

    public String toString() {
        return this.expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "variables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "namespaces";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/xpathView/HistoryElement";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

