/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorConstants;
import com.intellij.psi.css.impl.util.table.CssFontFamilyDescriptor;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class CssFontFamilyReference
extends PsiReferenceBase<CssString>
implements CssReference {
    public CssFontFamilyReference(CssString element) {
        super((PsiElement)element);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Unknown font-family" == null) {
            CssFontFamilyReference.$$$reportNull$$$0(0);
        }
        return "Unknown font-family";
    }

    public TextRange calculateDefaultRangeInElement() {
        CssString element = (CssString)this.getElement();
        String elementText = element.getText();
        if (elementText != null && StringUtil.isQuotedString((String)elementText.trim())) {
            int startIndex;
            int endIndex = elementText.length() - 1;
            for (startIndex = 0; startIndex < elementText.length() && Character.isWhitespace(elementText.charAt(startIndex)); ++startIndex) {
            }
            while (endIndex >= 0 && Character.isWhitespace(elementText.charAt(endIndex))) {
                --endIndex;
            }
            return TextRange.create((int)(startIndex + 1), (int)endIndex);
        }
        return TextRange.EMPTY_RANGE;
    }

    @NotNull
    public String getCanonicalText() {
        String string = ((CssString)this.getElement()).getValue();
        if (string == null) {
            CssFontFamilyReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement resolve() {
        return this.getElement();
    }

    @NotNull
    public Object[] getVariants() {
        CssTermList termList = (CssTermList)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, CssTermList.class);
        HashSet result = ContainerUtil.newHashSet(CssElementDescriptorConstants.GENERIC_FONT_NAMES);
        if (termList != null) {
            Collections.addAll(result, CssFontFamilyDescriptor.getPopularFontFamilies(this.myElement, termList));
            Collections.addAll(result, CssFontFamilyDescriptor.getSystemFontFamilies());
        }
        Object[] objectArray = ArrayUtil.toStringArray((Collection)result);
        if (objectArray == null) {
            CssFontFamilyReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/css/impl/util/references/CssFontFamilyReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

