/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.resolve.CssComposesClassReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssValueReference;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssUnresolvedClassInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssUnresolvedClassInspection.$$$reportNull$$$0(0);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration declaration) {
                if (!CssPropertyUtil.isComposesProperty(declaration) || declaration.getValue() == null) {
                    return;
                }
                CssTerm[] terms = declaration.getValue().getTerms();
                if (!CssUnresolvedClassInspection.isFilePathResolved(terms)) {
                    return;
                }
                for (CssTerm term : terms) {
                    CssUnresolvedClassInspection.checkTerm(holder, term);
                }
            }
        };
        if (cssElementVisitor == null) {
            CssUnresolvedClassInspection.$$$reportNull$$$0(1);
        }
        return cssElementVisitor;
    }

    private static void checkTerm(@NotNull ProblemsHolder holder, @NotNull CssTerm term) {
        if (holder == null) {
            CssUnresolvedClassInspection.$$$reportNull$$$0(2);
        }
        if (term == null) {
            CssUnresolvedClassInspection.$$$reportNull$$$0(3);
        }
        PsiElement child = term.getFirstChild();
        PsiReference[] references = child.getReferences();
        for (int i = 0; i < references.length; ++i) {
            PsiReference reference = references[i];
            if (reference instanceof CssValueReference && reference.resolve() != null) {
                return;
            }
            if (!(reference instanceof CssComposesClassReference) || !ArrayUtil.isEmpty((Object[])((CssComposesClassReference)reference).multiResolve(false))) continue;
            for (int j = i + 1; j < references.length; ++j) {
                PsiReference otherReference = references[j];
                if (!(otherReference instanceof CssValueReference) || otherReference.resolve() == null) continue;
                return;
            }
            holder.registerProblem(child, ((CssComposesClassReference)reference).getUnresolvedMessagePattern(), new LocalQuickFix[0]);
        }
    }

    private static boolean isFilePathResolved(@NotNull CssTerm[] terms) {
        CssTerm lastTerm;
        if (terms == null) {
            CssUnresolvedClassInspection.$$$reportNull$$$0(4);
        }
        if ((lastTerm = (CssTerm)ArrayUtil.getLastElement((Object[])terms)) == null) {
            return false;
        }
        return lastTerm.getTermType() != CssTermTypes.STRING || !ArrayUtil.isEmpty((Object[])CssResolveManager.getInstance().resolveFiles(lastTerm.getFirstChild()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssUnresolvedClassInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssUnresolvedClassInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkTerm";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFilePathResolved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

